/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteProcessor;
import com.google.common.io.Java8Compatibility;
import com.google.common.io.ParametricNullness;
import com.google.common.math.IntMath;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import org.jspecify.annotations.Nullable;

@GwtIncompatible
public final class ByteStreams {
    private static final int BUFFER_SIZE = 8192;
    private static final int ZERO_COPY_CHUNK_SIZE = 524288;
    private static final int MAX_ARRAY_LEN = 0x7FFFFFF7;
    private static final int TO_BYTE_ARRAY_DEQUE_SIZE = 20;
    private static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int b15) {
        }

        @Override
        public void write(byte[] b15) {
            Preconditions.checkNotNull(b15);
        }

        @Override
        public void write(byte[] b15, int off, int len) {
            Preconditions.checkNotNull(b15);
            Preconditions.checkPositionIndexes(off, off + len, b15.length);
        }

        public String toString() {
            return "ByteStreams.nullOutputStream()";
        }
    };

    static byte[] createBuffer() {
        return new byte[8192];
    }

    private ByteStreams() {
    }

    @CanIgnoreReturnValue
    public static long copy(InputStream from, OutputStream to4) throws IOException {
        int r15;
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to4);
        byte[] buf = ByteStreams.createBuffer();
        long total = 0L;
        while ((r15 = from.read(buf)) != -1) {
            to4.write(buf, 0, r15);
            total += (long)r15;
        }
        return total;
    }

    @J2ktIncompatible
    @CanIgnoreReturnValue
    public static long copy(ReadableByteChannel from, WritableByteChannel to4) throws IOException {
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to4);
        if (from instanceof FileChannel) {
            long copied;
            long oldPosition;
            FileChannel sourceChannel = (FileChannel)from;
            long position = oldPosition = sourceChannel.position();
            do {
                copied = sourceChannel.transferTo(position, 524288L, to4);
                sourceChannel.position(position += copied);
            } while (copied > 0L || position < sourceChannel.size());
            return position - oldPosition;
        }
        ByteBuffer buf = ByteBuffer.wrap(ByteStreams.createBuffer());
        long total = 0L;
        while (from.read(buf) != -1) {
            Java8Compatibility.flip(buf);
            while (buf.hasRemaining()) {
                total += (long)to4.write(buf);
            }
            Java8Compatibility.clear(buf);
        }
        return total;
    }

    private static byte[] toByteArrayInternal(InputStream in4, Queue<byte[]> bufs, int totalLen) throws IOException {
        int initialBufferSize;
        int bufSize = initialBufferSize = Math.min(8192, Math.max(128, Integer.highestOneBit(totalLen) * 2));
        while (totalLen < 0x7FFFFFF7) {
            byte[] buf = new byte[Math.min(bufSize, 0x7FFFFFF7 - totalLen)];
            bufs.add(buf);
            int off = 0;
            while (off < buf.length) {
                int r15 = in4.read(buf, off, buf.length - off);
                if (r15 == -1) {
                    return ByteStreams.combineBuffers(bufs, totalLen);
                }
                off += r15;
                totalLen += r15;
            }
            bufSize = IntMath.saturatedMultiply(bufSize, bufSize < 4096 ? 4 : 2);
        }
        if (in4.read() == -1) {
            return ByteStreams.combineBuffers(bufs, 0x7FFFFFF7);
        }
        throw new OutOfMemoryError("input is too large to fit in a byte array");
    }

    private static byte[] combineBuffers(Queue<byte[]> bufs, int totalLen) {
        if (bufs.isEmpty()) {
            return new byte[0];
        }
        byte[] result = bufs.remove();
        if (result.length == totalLen) {
            return result;
        }
        int remaining = totalLen - result.length;
        result = Arrays.copyOf(result, totalLen);
        while (remaining > 0) {
            byte[] buf = bufs.remove();
            int bytesToCopy = Math.min(remaining, buf.length);
            int resultOffset = totalLen - remaining;
            System.arraycopy(buf, 0, result, resultOffset, bytesToCopy);
            remaining -= bytesToCopy;
        }
        return result;
    }

    public static byte[] toByteArray(InputStream in4) throws IOException {
        Preconditions.checkNotNull(in4);
        return ByteStreams.toByteArrayInternal(in4, new ArrayDeque<byte[]>(20), 0);
    }

    static byte[] toByteArray(InputStream in4, long expectedSize) throws IOException {
        int read;
        Preconditions.checkArgument(expectedSize >= 0L, "expectedSize (%s) must be non-negative", expectedSize);
        if (expectedSize > 0x7FFFFFF7L) {
            throw new OutOfMemoryError(expectedSize + " bytes is too large to fit in a byte array");
        }
        byte[] bytes = new byte[(int)expectedSize];
        for (int remaining = (int)expectedSize; remaining > 0; remaining -= read) {
            int off = (int)expectedSize - remaining;
            read = in4.read(bytes, off, remaining);
            if (read != -1) continue;
            return Arrays.copyOf(bytes, off);
        }
        int b15 = in4.read();
        if (b15 == -1) {
            return bytes;
        }
        ArrayDeque<byte[]> bufs = new ArrayDeque<byte[]>(22);
        bufs.add(bytes);
        bufs.add(new byte[]{(byte)b15});
        return ByteStreams.toByteArrayInternal(in4, bufs, bytes.length + 1);
    }

    @CanIgnoreReturnValue
    public static long exhaust(InputStream in4) throws IOException {
        long read;
        long total = 0L;
        byte[] buf = ByteStreams.createBuffer();
        while ((read = (long)in4.read(buf)) != -1L) {
            total += read;
        }
        return total;
    }

    @J2ktIncompatible
    public static ByteArrayDataInput newDataInput(byte[] bytes) {
        return ByteStreams.newDataInput(new ByteArrayInputStream(bytes));
    }

    @J2ktIncompatible
    public static ByteArrayDataInput newDataInput(byte[] bytes, int start) {
        Preconditions.checkPositionIndex(start, bytes.length);
        return ByteStreams.newDataInput(new ByteArrayInputStream(bytes, start, bytes.length - start));
    }

    @J2ktIncompatible
    public static ByteArrayDataInput newDataInput(ByteArrayInputStream byteArrayInputStream) {
        return new ByteArrayDataInputStream(Preconditions.checkNotNull(byteArrayInputStream));
    }

    @J2ktIncompatible
    public static ByteArrayDataOutput newDataOutput() {
        return ByteStreams.newDataOutput(new ByteArrayOutputStream());
    }

    @J2ktIncompatible
    public static ByteArrayDataOutput newDataOutput(int size) {
        if (size < 0) {
            throw new IllegalArgumentException(String.format("Invalid size: %s", size));
        }
        return ByteStreams.newDataOutput(new ByteArrayOutputStream(size));
    }

    @J2ktIncompatible
    public static ByteArrayDataOutput newDataOutput(ByteArrayOutputStream byteArrayOutputStream) {
        return new ByteArrayDataOutputStream(Preconditions.checkNotNull(byteArrayOutputStream));
    }

    public static OutputStream nullOutputStream() {
        return NULL_OUTPUT_STREAM;
    }

    @J2ktIncompatible
    public static InputStream limit(InputStream in4, long limit) {
        return new LimitedInputStream(in4, limit);
    }

    public static void readFully(InputStream in4, byte[] b15) throws IOException {
        ByteStreams.readFully(in4, b15, 0, b15.length);
    }

    public static void readFully(InputStream in4, byte[] b15, int off, int len) throws IOException {
        int read = ByteStreams.read(in4, b15, off, len);
        if (read != len) {
            throw new EOFException("reached end of stream after reading " + read + " bytes; " + len + " bytes expected");
        }
    }

    public static void skipFully(InputStream in4, long n15) throws IOException {
        long skipped = ByteStreams.skipUpTo(in4, n15);
        if (skipped < n15) {
            throw new EOFException("reached end of stream after skipping " + skipped + " bytes; " + n15 + " bytes expected");
        }
    }

    static long skipUpTo(InputStream in4, long n15) throws IOException {
        long totalSkipped;
        long skipped;
        byte[] buf = null;
        for (totalSkipped = 0L; totalSkipped < n15; totalSkipped += skipped) {
            long remaining = n15 - totalSkipped;
            skipped = ByteStreams.skipSafely(in4, remaining);
            if (skipped != 0L) continue;
            int skip = (int)Math.min(remaining, 8192L);
            if (buf == null) {
                buf = new byte[skip];
            }
            if ((skipped = (long)in4.read(buf, 0, skip)) == -1L) break;
        }
        return totalSkipped;
    }

    private static long skipSafely(InputStream in4, long n15) throws IOException {
        int available = in4.available();
        return available == 0 ? 0L : in4.skip(Math.min((long)available, n15));
    }

    @CanIgnoreReturnValue
    @ParametricNullness
    @J2ktIncompatible
    public static <T> T readBytes(InputStream input, ByteProcessor<T> processor) throws IOException {
        int read;
        Preconditions.checkNotNull(input);
        Preconditions.checkNotNull(processor);
        byte[] buf = ByteStreams.createBuffer();
        while ((read = input.read(buf)) != -1 && processor.processBytes(buf, 0, read)) {
        }
        return processor.getResult();
    }

    @CanIgnoreReturnValue
    public static int read(InputStream in4, byte[] b15, int off, int len) throws IOException {
        int total;
        int result;
        Preconditions.checkNotNull(in4);
        Preconditions.checkNotNull(b15);
        if (len < 0) {
            throw new IndexOutOfBoundsException(String.format("len (%s) cannot be negative", len));
        }
        Preconditions.checkPositionIndexes(off, off + len, b15.length);
        for (total = 0; total < len && (result = in4.read(b15, off + total, len - total)) != -1; total += result) {
        }
        return total;
    }

    static boolean contentsEqual(InputStream in12, InputStream in22) throws IOException {
        int read1;
        byte[] buf1 = ByteStreams.createBuffer();
        byte[] buf2 = ByteStreams.createBuffer();
        do {
            int read2;
            if ((read1 = ByteStreams.read(in12, buf1, 0, 8192)) == (read2 = ByteStreams.read(in22, buf2, 0, 8192)) && ByteStreams.arraysEqual(buf1, buf2, read1)) continue;
            return false;
        } while (read1 == 8192);
        return true;
    }

    private static boolean arraysEqual(byte[] array1, byte[] array2, int count) {
        for (int i15 = 0; i15 < count; ++i15) {
            if (array1[i15] == array2[i15]) continue;
            return false;
        }
        return true;
    }

    @J2ktIncompatible
    private static final class ByteArrayDataInputStream
    implements ByteArrayDataInput {
        final DataInput input;

        ByteArrayDataInputStream(ByteArrayInputStream byteArrayInputStream) {
            this.input = new DataInputStream(byteArrayInputStream);
        }

        @Override
        public void readFully(byte[] b15) {
            try {
                this.input.readFully(b15);
            }
            catch (IOException e15) {
                throw new IllegalStateException(e15);
            }
        }

        @Override
        public void readFully(byte[] b15, int off, int len) {
            try {
                this.input.readFully(b15, off, len);
            }
            catch (IOException e15) {
                throw new IllegalStateException(e15);
            }
        }

        @Override
        public int skipBytes(int n15) {
            try {
                return this.input.skipBytes(n15);
            }
            catch (IOException e15) {
                throw new IllegalStateException(e15);
            }
        }

        @Override
        public boolean readBoolean() {
            try {
                return this.input.readBoolean();
            }
            catch (IOException e15) {
                throw new IllegalStateException(e15);
            }
        }

        @Override
        public byte readByte() {
            try {
                return this.input.readByte();
            }
            catch (EOFException e15) {
                throw new IllegalStateException(e15);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public int readUnsignedByte() {
            try {
                return this.input.readUnsignedByte();
            }
            catch (IOException e15) {
                throw new IllegalStateException(e15);
            }
        }

        @Override
        public short readShort() {
            try {
                return this.input.readShort();
            }
            catch (IOException e15) {
                throw new IllegalStateException(e15);
            }
        }

        @Override
        public int readUnsignedShort() {
            try {
                return this.input.readUnsignedShort();
            }
            catch (IOException e15) {
                throw new IllegalStateException(e15);
            }
        }

        @Override
        public char readChar() {
            try {
                return this.input.readChar();
            }
            catch (IOException e15) {
                throw new IllegalStateException(e15);
            }
        }

        @Override
        public int readInt() {
            try {
                return this.input.readInt();
            }
            catch (IOException e15) {
                throw new IllegalStateException(e15);
            }
        }

        @Override
        public long readLong() {
            try {
                return this.input.readLong();
            }
            catch (IOException e15) {
                throw new IllegalStateException(e15);
            }
        }

        @Override
        public float readFloat() {
            try {
                return this.input.readFloat();
            }
            catch (IOException e15) {
                throw new IllegalStateException(e15);
            }
        }

        @Override
        public double readDouble() {
            try {
                return this.input.readDouble();
            }
            catch (IOException e15) {
                throw new IllegalStateException(e15);
            }
        }

        @Override
        public @Nullable String readLine() {
            try {
                return this.input.readLine();
            }
            catch (IOException e15) {
                throw new IllegalStateException(e15);
            }
        }

        @Override
        public String readUTF() {
            try {
                return this.input.readUTF();
            }
            catch (IOException e15) {
                throw new IllegalStateException(e15);
            }
        }
    }

    @J2ktIncompatible
    private static final class ByteArrayDataOutputStream
    implements ByteArrayDataOutput {
        final DataOutput output;
        final ByteArrayOutputStream byteArrayOutputStream;

        ByteArrayDataOutputStream(ByteArrayOutputStream byteArrayOutputStream) {
            this.byteArrayOutputStream = byteArrayOutputStream;
            this.output = new DataOutputStream(byteArrayOutputStream);
        }

        @Override
        public void write(int b15) {
            try {
                this.output.write(b15);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void write(byte[] b15) {
            try {
                this.output.write(b15);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void write(byte[] b15, int off, int len) {
            try {
                this.output.write(b15, off, len);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeBoolean(boolean v15) {
            try {
                this.output.writeBoolean(v15);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeByte(int v15) {
            try {
                this.output.writeByte(v15);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeBytes(String s15) {
            try {
                this.output.writeBytes(s15);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeChar(int v15) {
            try {
                this.output.writeChar(v15);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeChars(String s15) {
            try {
                this.output.writeChars(s15);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeDouble(double v15) {
            try {
                this.output.writeDouble(v15);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeFloat(float v15) {
            try {
                this.output.writeFloat(v15);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeInt(int v15) {
            try {
                this.output.writeInt(v15);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeLong(long v15) {
            try {
                this.output.writeLong(v15);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeShort(int v15) {
            try {
                this.output.writeShort(v15);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeUTF(String s15) {
            try {
                this.output.writeUTF(s15);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public byte[] toByteArray() {
            return this.byteArrayOutputStream.toByteArray();
        }
    }

    @J2ktIncompatible
    private static final class LimitedInputStream
    extends FilterInputStream {
        private long left;
        private long mark = -1L;

        LimitedInputStream(InputStream in4, long limit) {
            super(in4);
            Preconditions.checkNotNull(in4);
            Preconditions.checkArgument(limit >= 0L, "limit must be non-negative");
            this.left = limit;
        }

        @Override
        public int available() throws IOException {
            return (int)Math.min((long)this.in.available(), this.left);
        }

        @Override
        public synchronized void mark(int readLimit) {
            this.in.mark(readLimit);
            this.mark = this.left;
        }

        @Override
        public int read() throws IOException {
            if (this.left == 0L) {
                return -1;
            }
            int result = this.in.read();
            if (result != -1) {
                --this.left;
            }
            return result;
        }

        @Override
        public int read(byte[] b15, int off, int len) throws IOException {
            if (this.left == 0L) {
                return -1;
            }
            int result = this.in.read(b15, off, len = (int)Math.min((long)len, this.left));
            if (result != -1) {
                this.left -= (long)result;
            }
            return result;
        }

        @Override
        public synchronized void reset() throws IOException {
            if (!this.in.markSupported()) {
                throw new IOException("Mark not supported");
            }
            if (this.mark == -1L) {
                throw new IOException("Mark not set");
            }
            this.in.reset();
            this.left = this.mark;
        }

        @Override
        public long skip(long n15) throws IOException {
            n15 = Math.min(n15, this.left);
            long skipped = this.in.skip(n15);
            this.left -= skipped;
            return skipped;
        }
    }
}

