/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;

class IIOInputStreamAdapter
extends InputStream {
    private ImageInputStream input;
    private final boolean hasLength;
    private long left;
    private long markPosition;

    public IIOInputStreamAdapter(ImageInputStream imageInputStream) {
        this(imageInputStream, -1L, false);
    }

    public IIOInputStreamAdapter(ImageInputStream imageInputStream, long l15) {
        this(imageInputStream, l15, true);
    }

    private IIOInputStreamAdapter(ImageInputStream imageInputStream, long l15, boolean bl4) {
        Validate.notNull(imageInputStream, "stream");
        Validate.isTrue(!bl4 || l15 >= 0L, l15, "length < 0: %d");
        this.input = imageInputStream;
        this.left = l15;
        this.hasLength = bl4;
    }

    @Override
    public void close() throws IOException {
        if (this.hasLength) {
            this.input.seek(this.input.getStreamPosition() + this.left);
        }
        this.left = 0L;
        this.input = null;
    }

    @Override
    public int available() throws IOException {
        if (this.hasLength) {
            return this.left > 0L ? (int)Math.min(Integer.MAX_VALUE, this.left) : 0;
        }
        return 0;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n15) {
        try {
            this.markPosition = this.input.getStreamPosition();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not read stream position: " + iOException.getMessage(), iOException);
        }
    }

    @Override
    public void reset() throws IOException {
        long l15 = this.input.getStreamPosition() - this.markPosition;
        this.input.seek(this.markPosition);
        this.left += l15;
    }

    @Override
    public int read() throws IOException {
        if (this.hasLength && this.left-- <= 0L) {
            this.left = 0L;
            return -1;
        }
        return this.input.read();
    }

    @Override
    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n15, int n16) throws IOException {
        if (this.hasLength && this.left <= 0L) {
            return -1;
        }
        int n17 = this.input.read(byArray, n15, (int)this.findMaxLen(n16));
        if (this.hasLength) {
            this.left = n17 < 0 ? 0L : this.left - (long)n17;
        }
        return n17;
    }

    private long findMaxLen(long l15) {
        if (this.hasLength && this.left < l15) {
            return Math.max(this.left, 0L);
        }
        return Math.max(l15, 0L);
    }

    @Override
    public long skip(long l15) throws IOException {
        long l16 = this.input.skipBytes(this.findMaxLen(l15));
        this.left -= l16;
        return l16;
    }
}

