/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.lang.Validate;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class SubStream
extends FilterInputStream {
    private long bytesLeft;
    private int markLimit;

    public SubStream(InputStream inputStream, long l15) {
        super(Validate.notNull(inputStream, "stream"));
        this.bytesLeft = Validate.isTrue(l15 >= 0L, l15, "length < 0: %s");
    }

    @Override
    public void close() throws IOException {
        while (this.bytesLeft > 0L && (this.skip(this.bytesLeft) > 0L || this.read() >= 0)) {
        }
    }

    @Override
    public int available() throws IOException {
        return (int)this.findMaxLen(super.available());
    }

    @Override
    public void mark(int n15) {
        super.mark(n15);
        this.markLimit = n15;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.bytesLeft += (long)this.markLimit;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesLeft-- <= 0L) {
            return -1;
        }
        return super.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n15, int n16) throws IOException {
        if (this.bytesLeft <= 0L) {
            return -1;
        }
        int n17 = super.read(byArray, n15, (int)this.findMaxLen(n16));
        this.bytesLeft = n17 < 0 ? 0L : this.bytesLeft - (long)n17;
        return n17;
    }

    @Override
    public long skip(long l15) throws IOException {
        long l16 = super.skip(this.findMaxLen(l15));
        this.bytesLeft -= l16;
        return l16;
    }

    private long findMaxLen(long l15) {
        return this.bytesLeft < l15 ? Math.max(this.bytesLeft, 0L) : l15;
    }
}

