/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.util.AbstractTokenIterator;
import java.util.NoSuchElementException;

public class StringTokenIterator
extends AbstractTokenIterator {
    private final String string;
    private final char[] delimiters;
    private int position;
    private final int maxPosition;
    private String next;
    private String nextDelimiter;
    private final boolean includeDelimiters;
    private final boolean includeEmpty;
    private final boolean reverse;
    public static final int FORWARD = 1;
    public static final int REVERSE = -1;
    private final char maxDelimiter;

    public StringTokenIterator(String string) {
        this(string, " \t\n\r\f".toCharArray(), 1, false, false);
    }

    public StringTokenIterator(String string, String string2) {
        this(string, StringTokenIterator.toCharArray(string2), 1, false, false);
    }

    public StringTokenIterator(String string, String string2, int n15) {
        this(string, StringTokenIterator.toCharArray(string2), n15, false, false);
    }

    public StringTokenIterator(String string, String string2, boolean bl4) {
        this(string, StringTokenIterator.toCharArray(string2), 1, bl4, false);
    }

    public StringTokenIterator(String string, String string2, int n15, boolean bl4, boolean bl5) {
        this(string, StringTokenIterator.toCharArray(string2), n15, bl4, bl5);
    }

    private StringTokenIterator(String string, char[] cArray, int n15, boolean bl4, boolean bl5) {
        if (string == null) {
            throw new IllegalArgumentException("string == null");
        }
        this.string = string;
        this.maxPosition = string.length();
        this.delimiters = cArray;
        this.includeDelimiters = bl4;
        this.reverse = n15 == -1;
        this.includeEmpty = bl5;
        this.maxDelimiter = StringTokenIterator.initMaxDelimiter(cArray);
        this.reset();
    }

    private static char[] toCharArray(String string) {
        if (string == null) {
            throw new IllegalArgumentException("delimiters == null");
        }
        return string.toCharArray();
    }

    private static char initMaxDelimiter(char[] cArray) {
        if (cArray == null) {
            return '\u0000';
        }
        char c15 = '\u0000';
        for (char c16 : cArray) {
            if (c15 >= c16) continue;
            c15 = c16;
        }
        return c15;
    }

    @Override
    public void reset() {
        this.position = 0;
        this.next = null;
        this.nextDelimiter = null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null || this.fetchNext() != null;
    }

    private String fetchNext() {
        if (this.nextDelimiter != null) {
            this.next = this.nextDelimiter;
            this.nextDelimiter = null;
            return this.next;
        }
        if (this.position >= this.maxPosition) {
            return null;
        }
        return this.reverse ? this.fetchReverse() : this.fetchForward();
    }

    private String fetchReverse() {
        int n15 = this.scanForPrev();
        this.next = this.string.substring(n15 + 1, this.maxPosition - this.position);
        if (this.includeDelimiters && n15 >= 0 && n15 < this.maxPosition) {
            this.nextDelimiter = this.string.substring(n15, n15 + 1);
        }
        this.position = this.maxPosition - n15;
        if (this.next.length() == 0 && !this.includeEmpty) {
            return this.fetchNext();
        }
        return this.next;
    }

    private String fetchForward() {
        int n15 = this.scanForNext();
        this.next = this.string.substring(this.position, n15);
        if (this.includeDelimiters && n15 >= 0 && n15 < this.maxPosition) {
            this.nextDelimiter = this.string.substring(n15, n15 + 1);
        }
        this.position = ++n15;
        if (this.next.length() == 0 && !this.includeEmpty) {
            return this.fetchNext();
        }
        return this.next;
    }

    private int scanForNext() {
        int n15;
        for (n15 = this.position; n15 < this.maxPosition; ++n15) {
            char c15 = this.string.charAt(n15);
            if (c15 > this.maxDelimiter) continue;
            for (char c16 : this.delimiters) {
                if (c15 != c16) continue;
                return n15;
            }
        }
        return n15;
    }

    private int scanForPrev() {
        int n15;
        for (n15 = this.maxPosition - 1 - this.position; n15 >= 0; --n15) {
            char c15 = this.string.charAt(n15);
            if (c15 > this.maxDelimiter) continue;
            for (char c16 : this.delimiters) {
                if (c15 != c16) continue;
                return n15;
            }
        }
        return n15;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String string = this.next;
        this.next = this.fetchNext();
        return string;
    }
}

