/*
 * Decompiled with CFR 0.152.
 */
package hu.kazocsaba.imageviewer;

import hu.kazocsaba.imageviewer.ImageViewer;
import hu.kazocsaba.imageviewer.ResizeStrategy;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import javax.swing.JViewport;

class CustomViewportLayout
implements LayoutManager {
    private final ImageViewer viewer;

    public CustomViewportLayout(ImageViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        BufferedImage image = this.viewer.getImage();
        if (image == null) {
            return new Dimension();
        }
        return new Dimension(image.getWidth(), image.getHeight());
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(4, 4);
    }

    @Override
    public void layoutContainer(Container parent) {
        JViewport vp4 = (JViewport)parent;
        Component view = vp4.getView();
        if (view == null) {
            return;
        }
        Dimension vpSize = vp4.getSize();
        Dimension viewSize = new Dimension(view.getPreferredSize());
        if (this.viewer.getResizeStrategy() == ResizeStrategy.SHRINK_TO_FIT || this.viewer.getResizeStrategy() == ResizeStrategy.RESIZE_TO_FIT) {
            viewSize.width = vpSize.width;
            viewSize.height = vpSize.height;
        } else {
            viewSize.width = Math.max(viewSize.width, vpSize.width);
            viewSize.height = Math.max(viewSize.height, vpSize.height);
        }
        vp4.setViewSize(viewSize);
    }
}

