/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.common.utils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);
    private static final Object MKDIR_SYNC = new Object();

    public static List<Path> expandDirs(List<Path> paths) {
        ArrayList<Path> files = new ArrayList<Path>(paths.size());
        for (Path path : paths) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                FileUtils.expandDir(path, files);
                continue;
            }
            files.add(path);
        }
        Collections.sort(files);
        return files;
    }

    public static List<Path> expandDir(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            ArrayList<Path> files = new ArrayList<Path>();
            FileUtils.expandDir(path, files);
            Collections.sort(files);
            return files;
        }
        return Collections.singletonList(path);
    }

    private static void expandDir(Path dir, List<Path> files) {
        try (Stream<Path> walk = Files.walk(dir, FileVisitOption.FOLLOW_LINKS);){
            walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(files::add);
        }
        catch (Exception e15) {
            LOG.error("Failed to list files in directory: {}", (Object)dir, (Object)e15);
        }
    }

    public static Path getParentDir(Path path) {
        Path parent = path.getParent();
        if (parent == null) {
            return Paths.get(".", new String[0]);
        }
        return parent;
    }

    public static void makeDirsForFile(Path file2) {
        if (file2 != null) {
            FileUtils.makeDirs(file2.getParent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeDirs(@Nullable Path dir) {
        if (dir != null) {
            Object object = MKDIR_SYNC;
            synchronized (object) {
                try {
                    Files.createDirectories(dir, new FileAttribute[0]);
                }
                catch (IOException e15) {
                    throw new RuntimeException("Can't create directory " + dir, e15);
                }
            }
        }
    }

    public static void saveFile(Path output, String fileName, String code) {
        Path file2 = output.resolve(fileName);
        FileUtils.saveFile(file2, code);
    }

    public static void saveFile(Path file2, String code) {
        FileUtils.makeDirsForFile(file2);
        try (BufferedWriter writer = Files.newBufferedWriter(file2, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(code);
        }
        catch (Exception e15) {
            throw new RuntimeException("File save failed: " + file2.toAbsolutePath(), e15);
        }
    }

    public static void saveInputStream(Path output, String fileName, InputStream inputStream) {
        Path file2 = output.resolve(fileName);
        FileUtils.makeDirsForFile(file2);
        try {
            Files.copy(inputStream, file2, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e15) {
            throw new RuntimeException("File save failed: " + file2.toAbsolutePath(), e15);
        }
    }

    @Nullable
    public static String getExt(@Nullable Path path) {
        if (path == null) {
            return null;
        }
        String name = path.getFileName().toString();
        int extIdx = name.lastIndexOf(46);
        if (extIdx == -1 || extIdx == name.length() - 1) {
            return null;
        }
        return name.substring(extIdx + 1);
    }

    public static void checkInputFile(Path file2) {
        if (file2 == null) {
            throw new IllegalArgumentException("Input file should be set");
        }
        if (!Files.exists(file2, new LinkOption[0])) {
            throw new IllegalArgumentException("File not found: " + file2.toAbsolutePath());
        }
        if (Files.isDirectory(file2, new LinkOption[0])) {
            throw new IllegalArgumentException("Expect file but ogt directory: " + file2.toAbsolutePath());
        }
    }
}

