/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

abstract class FlowableStageSubscriber<T>
extends CompletableFuture<T>
implements FlowableSubscriber<T> {
    final AtomicReference<Subscription> upstream = new AtomicReference();
    T value;

    FlowableStageSubscriber() {
    }

    @Override
    public final void onSubscribe(@NonNull Subscription s15) {
        if (SubscriptionHelper.setOnce(this.upstream, s15)) {
            this.afterSubscribe(s15);
        }
    }

    protected abstract void afterSubscribe(Subscription var1);

    @Override
    public final void onError(Throwable t15) {
        this.clear();
        if (!this.completeExceptionally(t15)) {
            RxJavaPlugins.onError(t15);
        }
    }

    protected final void cancelUpstream() {
        SubscriptionHelper.cancel(this.upstream);
    }

    protected final void clear() {
        this.value = null;
        this.upstream.lazySet(SubscriptionHelper.CANCELLED);
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelUpstream();
        return super.cancel(mayInterruptIfRunning);
    }

    @Override
    public final boolean complete(T value) {
        this.cancelUpstream();
        return super.complete(value);
    }

    @Override
    public final boolean completeExceptionally(Throwable ex4) {
        this.cancelUpstream();
        return super.completeExceptionally(ex4);
    }
}

