/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.observers.BasicIntQueueDisposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;

public final class MaybeFlattenStreamAsObservable<T, R>
extends Observable<R> {
    final Maybe<T> source;
    final Function<? super T, ? extends Stream<? extends R>> mapper;

    public MaybeFlattenStreamAsObservable(Maybe<T> source, Function<? super T, ? extends Stream<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(@NonNull Observer<? super R> s15) {
        this.source.subscribe(new FlattenStreamMultiObserver<T, R>(s15, this.mapper));
    }

    static final class FlattenStreamMultiObserver<T, R>
    extends BasicIntQueueDisposable<R>
    implements MaybeObserver<T>,
    SingleObserver<T> {
        private static final long serialVersionUID = 7363336003027148283L;
        final Observer<? super R> downstream;
        final Function<? super T, ? extends Stream<? extends R>> mapper;
        Disposable upstream;
        volatile Iterator<? extends R> iterator;
        AutoCloseable close;
        boolean once;
        volatile boolean disposed;
        boolean outputFused;

        FlattenStreamMultiObserver(Observer<? super R> downstream, Function<? super T, ? extends Stream<? extends R>> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
        }

        @Override
        public void onSubscribe(@NonNull Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(@NonNull T t15) {
            try {
                Stream<R> stream = Objects.requireNonNull(this.mapper.apply(t15), "The mapper returned a null Stream");
                Iterator iterator2 = stream.iterator();
                Stream<R> c15 = stream;
                if (!iterator2.hasNext()) {
                    this.downstream.onComplete();
                    this.close(c15);
                    return;
                }
                this.iterator = iterator2;
                this.close = stream;
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.downstream.onError(ex4);
                return;
            }
            this.drain();
        }

        @Override
        public void onError(@NonNull Throwable e15) {
            this.downstream.onError(e15);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.upstream.dispose();
            if (!this.outputFused) {
                this.drain();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        @Nullable
        public R poll() throws Throwable {
            Iterator<R> it = this.iterator;
            if (it != null) {
                if (this.once) {
                    if (!it.hasNext()) {
                        this.clear();
                        return null;
                    }
                } else {
                    this.once = true;
                }
                return it.next();
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            Iterator<R> it = this.iterator;
            if (it != null) {
                if (!this.once) {
                    return false;
                }
                if (it.hasNext()) {
                    return false;
                }
                this.clear();
            }
            return true;
        }

        @Override
        public void clear() {
            this.iterator = null;
            AutoCloseable close = this.close;
            this.close = null;
            this.close(close);
        }

        void close(AutoCloseable c15) {
            try {
                if (c15 != null) {
                    c15.close();
                }
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                RxJavaPlugins.onError(ex4);
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer<R> downstream = this.downstream;
            Iterator<R> it = this.iterator;
            while (true) {
                if (this.disposed) {
                    this.clear();
                } else if (this.outputFused) {
                    downstream.onNext(null);
                    downstream.onComplete();
                } else {
                    boolean has;
                    R item;
                    try {
                        item = it.next();
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        downstream.onError(ex4);
                        this.disposed = true;
                        continue;
                    }
                    if (this.disposed) continue;
                    downstream.onNext(item);
                    if (this.disposed) continue;
                    try {
                        has = it.hasNext();
                    }
                    catch (Throwable ex5) {
                        Exceptions.throwIfFatal(ex5);
                        downstream.onError(ex5);
                        this.disposed = true;
                        continue;
                    }
                    if (this.disposed || has) continue;
                    downstream.onComplete();
                    this.disposed = true;
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

