/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSkipLastTimed<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;
    final int bufferSize;
    final boolean delayError;

    public FlowableSkipLastTimed(Flowable<T> source, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
        super(source);
        this.time = time;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        this.source.subscribe(new SkipLastTimedSubscriber<T>(s15, this.time, this.unit, this.scheduler, this.bufferSize, this.delayError));
    }

    static final class SkipLastTimedSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -5677354903406201275L;
        final Subscriber<? super T> downstream;
        final long time;
        final TimeUnit unit;
        final Scheduler scheduler;
        final SpscLinkedArrayQueue<Object> queue;
        final boolean delayError;
        Subscription upstream;
        final AtomicLong requested = new AtomicLong();
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;

        SkipLastTimedSubscriber(Subscriber<? super T> actual, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
            this.downstream = actual;
            this.time = time;
            this.unit = unit;
            this.scheduler = scheduler;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.delayError = delayError;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                s15.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t15) {
            long now = this.scheduler.now(this.unit);
            this.queue.offer(now, t15);
            this.drain();
        }

        @Override
        public void onError(Throwable t15) {
            this.error = t15;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<Object> a15 = this.downstream;
            SpscLinkedArrayQueue<Object> q15 = this.queue;
            boolean delayError = this.delayError;
            TimeUnit unit = this.unit;
            Scheduler scheduler = this.scheduler;
            long time = this.time;
            do {
                long e15;
                long r15 = this.requested.get();
                for (e15 = 0L; e15 != r15; ++e15) {
                    boolean d15 = this.done;
                    Long ts4 = (Long)q15.peek();
                    boolean empty = ts4 == null;
                    long now = scheduler.now(unit);
                    if (!empty && ts4 > now - time) {
                        empty = true;
                    }
                    if (this.checkTerminated(d15, empty, a15, delayError)) {
                        return;
                    }
                    if (empty) break;
                    q15.poll();
                    Object v15 = q15.poll();
                    a15.onNext(v15);
                }
                if (e15 == 0L) continue;
                BackpressureHelper.produced(this.requested, e15);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        boolean checkTerminated(boolean d15, boolean empty, Subscriber<? super T> a15, boolean delayError) {
            if (this.cancelled) {
                this.queue.clear();
                return true;
            }
            if (d15) {
                if (delayError) {
                    if (empty) {
                        Throwable e15 = this.error;
                        if (e15 != null) {
                            a15.onError(e15);
                        } else {
                            a15.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable e16 = this.error;
                    if (e16 != null) {
                        this.queue.clear();
                        a15.onError(e16);
                        return true;
                    }
                    if (empty) {
                        a15.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

