/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableScalarXMap;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSwitchMap<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final int bufferSize;
    final boolean delayErrors;

    public FlowableSwitchMap(Flowable<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, int bufferSize, boolean delayErrors) {
        super(source);
        this.mapper = mapper;
        this.bufferSize = bufferSize;
        this.delayErrors = delayErrors;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s15) {
        if (FlowableScalarXMap.tryScalarXMapSubscribe(this.source, s15, this.mapper)) {
            return;
        }
        this.source.subscribe(new SwitchMapSubscriber<T, R>(s15, this.mapper, this.bufferSize, this.delayErrors));
    }

    static final class SwitchMapInnerSubscriber<T, R>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<R> {
        private static final long serialVersionUID = 3837284832786408377L;
        final SwitchMapSubscriber<T, R> parent;
        final long index;
        final int bufferSize;
        volatile SimpleQueue<R> queue;
        volatile boolean done;
        int fusionMode;

        SwitchMapInnerSubscriber(SwitchMapSubscriber<T, R> parent, long index, int bufferSize) {
            this.parent = parent;
            this.index = index;
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.setOnce(this, s15)) {
                if (s15 instanceof QueueSubscription) {
                    QueueSubscription qs4 = (QueueSubscription)s15;
                    int m15 = qs4.requestFusion(7);
                    if (m15 == 1) {
                        this.fusionMode = m15;
                        this.queue = qs4;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m15 == 2) {
                        this.fusionMode = m15;
                        this.queue = qs4;
                        s15.request(this.bufferSize);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<R>(this.bufferSize);
                s15.request(this.bufferSize);
            }
        }

        @Override
        public void onNext(R t15) {
            SwitchMapSubscriber<T, R> p15 = this.parent;
            if (this.index == p15.unique) {
                if (this.fusionMode == 0 && !this.queue.offer(t15)) {
                    this.onError(new QueueOverflowException());
                    return;
                }
                p15.drain();
            }
        }

        @Override
        public void onError(Throwable t15) {
            SwitchMapSubscriber<T, R> p15 = this.parent;
            if (this.index == p15.unique && p15.errors.tryAddThrowable(t15)) {
                if (!p15.delayErrors) {
                    p15.upstream.cancel();
                    p15.done = true;
                }
                this.done = true;
                p15.drain();
            } else {
                RxJavaPlugins.onError(t15);
            }
        }

        @Override
        public void onComplete() {
            SwitchMapSubscriber<T, R> p15 = this.parent;
            if (this.index == p15.unique) {
                this.done = true;
                p15.drain();
            }
        }

        public void cancel() {
            SubscriptionHelper.cancel(this);
        }

        public void request(long n15) {
            if (this.fusionMode != 1) {
                ((Subscription)this.get()).request(n15);
            }
        }
    }

    static final class SwitchMapSubscriber<T, R>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -3491074160481096299L;
        final Subscriber<? super R> downstream;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final int bufferSize;
        final boolean delayErrors;
        volatile boolean done;
        final AtomicThrowable errors;
        volatile boolean cancelled;
        Subscription upstream;
        final AtomicReference<SwitchMapInnerSubscriber<T, R>> active = new AtomicReference();
        final AtomicLong requested = new AtomicLong();
        static final SwitchMapInnerSubscriber<Object, Object> CANCELLED = new SwitchMapInnerSubscriber(null, -1L, 1);
        volatile long unique;

        SwitchMapSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, int bufferSize, boolean delayErrors) {
            this.downstream = actual;
            this.mapper = mapper;
            this.bufferSize = bufferSize;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            Publisher<R> p15;
            long c15;
            if (this.done) {
                return;
            }
            this.unique = c15 = this.unique + 1L;
            SwitchMapInnerSubscriber<T, R> inner = this.active.get();
            if (inner != null) {
                inner.cancel();
            }
            try {
                p15 = Objects.requireNonNull(this.mapper.apply(t15), "The publisher returned is null");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.upstream.cancel();
                this.onError(e15);
                return;
            }
            SwitchMapInnerSubscriber nextInner = new SwitchMapInnerSubscriber(this, c15, this.bufferSize);
            while ((inner = this.active.get()) != CANCELLED) {
                if (!this.active.compareAndSet(inner, nextInner)) continue;
                p15.subscribe(nextInner);
                break;
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (!this.done && this.errors.tryAddThrowable(t15)) {
                if (!this.delayErrors) {
                    this.disposeInner();
                }
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t15);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                if (this.unique == 0L) {
                    this.upstream.request(Long.MAX_VALUE);
                } else {
                    this.drain();
                }
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                this.disposeInner();
                this.errors.tryTerminateAndReport();
            }
        }

        void disposeInner() {
            SwitchMapInnerSubscriber<Object, Object> a15 = this.active.getAndSet(CANCELLED);
            if (a15 != CANCELLED && a15 != null) {
                a15.cancel();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Subscriber<R> a15 = this.downstream;
            int missing = 1;
            while (true) {
                SwitchMapInnerSubscriber<T, R> inner;
                SimpleQueue q15;
                if (this.cancelled) {
                    return;
                }
                if (this.done) {
                    if (this.delayErrors) {
                        if (this.active.get() == null) {
                            this.errors.tryTerminateConsumer(a15);
                            return;
                        }
                    } else {
                        Throwable err = (Throwable)this.errors.get();
                        if (err != null) {
                            this.disposeInner();
                            this.errors.tryTerminateConsumer(a15);
                            return;
                        }
                        if (this.active.get() == null) {
                            a15.onComplete();
                            return;
                        }
                    }
                }
                SimpleQueue simpleQueue = q15 = (inner = this.active.get()) != null ? inner.queue : null;
                if (q15 != null) {
                    long e15;
                    long r15 = this.requested.get();
                    boolean retry = false;
                    for (e15 = 0L; e15 != r15; ++e15) {
                        boolean empty;
                        Object v15;
                        if (this.cancelled) {
                            return;
                        }
                        boolean d15 = inner.done;
                        try {
                            v15 = q15.poll();
                        }
                        catch (Throwable ex4) {
                            Exceptions.throwIfFatal(ex4);
                            inner.cancel();
                            this.errors.tryAddThrowableOrReport(ex4);
                            d15 = true;
                            v15 = null;
                        }
                        boolean bl4 = empty = v15 == null;
                        if (inner != this.active.get()) {
                            retry = true;
                            break;
                        }
                        if (d15) {
                            if (!this.delayErrors) {
                                Throwable err = (Throwable)this.errors.get();
                                if (err != null) {
                                    this.errors.tryTerminateConsumer(a15);
                                    return;
                                }
                                if (empty) {
                                    this.active.compareAndSet(inner, null);
                                    retry = true;
                                    break;
                                }
                            } else if (empty) {
                                this.active.compareAndSet(inner, null);
                                retry = true;
                                break;
                            }
                        }
                        if (empty) break;
                        a15.onNext(v15);
                    }
                    if (e15 == r15 && inner.done) {
                        if (!this.delayErrors) {
                            Throwable err = (Throwable)this.errors.get();
                            if (err != null) {
                                this.disposeInner();
                                this.errors.tryTerminateConsumer(a15);
                                return;
                            }
                            if (q15.isEmpty()) {
                                this.active.compareAndSet(inner, null);
                                continue;
                            }
                        } else if (q15.isEmpty()) {
                            this.active.compareAndSet(inner, null);
                            continue;
                        }
                    }
                    if (e15 != 0L && !this.cancelled) {
                        if (r15 != Long.MAX_VALUE) {
                            this.requested.addAndGet(-e15);
                        }
                        inner.request(e15);
                    }
                    if (retry) continue;
                }
                if ((missing = this.addAndGet(-missing)) == 0) break;
            }
        }

        static {
            CANCELLED.cancel();
        }
    }
}

