/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeCache<T>
extends Maybe<T>
implements MaybeObserver<T> {
    static final CacheDisposable[] EMPTY = new CacheDisposable[0];
    static final CacheDisposable[] TERMINATED = new CacheDisposable[0];
    final AtomicReference<MaybeSource<T>> source;
    final AtomicReference<CacheDisposable<T>[]> observers;
    T value;
    Throwable error;

    public MaybeCache(MaybeSource<T> source) {
        this.source = new AtomicReference<MaybeSource<T>>(source);
        this.observers = new AtomicReference<CacheDisposable[]>(EMPTY);
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        CacheDisposable<T> parent = new CacheDisposable<T>(observer, this);
        observer.onSubscribe(parent);
        if (this.add(parent)) {
            if (parent.isDisposed()) {
                this.remove(parent);
                return;
            }
        } else {
            if (!parent.isDisposed()) {
                Throwable ex4 = this.error;
                if (ex4 != null) {
                    observer.onError(ex4);
                } else {
                    T v15 = this.value;
                    if (v15 != null) {
                        observer.onSuccess(v15);
                    } else {
                        observer.onComplete();
                    }
                }
            }
            return;
        }
        MaybeSource src = this.source.getAndSet(null);
        if (src != null) {
            src.subscribe(this);
        }
    }

    @Override
    public void onSubscribe(Disposable d15) {
    }

    @Override
    public void onSuccess(T value) {
        this.value = value;
        for (CacheDisposable inner : this.observers.getAndSet(TERMINATED)) {
            if (inner.isDisposed()) continue;
            inner.downstream.onSuccess(value);
        }
    }

    @Override
    public void onError(Throwable e15) {
        this.error = e15;
        for (CacheDisposable inner : this.observers.getAndSet(TERMINATED)) {
            if (inner.isDisposed()) continue;
            inner.downstream.onError(e15);
        }
    }

    @Override
    public void onComplete() {
        for (CacheDisposable inner : this.observers.getAndSet(TERMINATED)) {
            if (inner.isDisposed()) continue;
            inner.downstream.onComplete();
        }
    }

    boolean add(CacheDisposable<T> inner) {
        CacheDisposable[] b15;
        CacheDisposable<T>[] a15;
        do {
            if ((a15 = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n15 = a15.length;
            b15 = new CacheDisposable[n15 + 1];
            System.arraycopy(a15, 0, b15, 0, n15);
            b15[n15] = inner;
        } while (!this.observers.compareAndSet(a15, b15));
        return true;
    }

    void remove(CacheDisposable<T> inner) {
        CacheDisposable[] b15;
        CacheDisposable<T>[] a15;
        do {
            int n15;
            if ((n15 = (a15 = this.observers.get()).length) == 0) {
                return;
            }
            int j15 = -1;
            for (int i15 = 0; i15 < n15; ++i15) {
                if (a15[i15] != inner) continue;
                j15 = i15;
                break;
            }
            if (j15 < 0) {
                return;
            }
            if (n15 == 1) {
                b15 = EMPTY;
                continue;
            }
            b15 = new CacheDisposable[n15 - 1];
            System.arraycopy(a15, 0, b15, 0, j15);
            System.arraycopy(a15, j15 + 1, b15, j15, n15 - j15 - 1);
        } while (!this.observers.compareAndSet(a15, b15));
    }

    static final class CacheDisposable<T>
    extends AtomicReference<MaybeCache<T>>
    implements Disposable {
        private static final long serialVersionUID = -5791853038359966195L;
        final MaybeObserver<? super T> downstream;

        CacheDisposable(MaybeObserver<? super T> actual, MaybeCache<T> parent) {
            super(parent);
            this.downstream = actual;
        }

        @Override
        public void dispose() {
            MaybeCache mc5 = this.getAndSet(null);
            if (mc5 != null) {
                mc5.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get() == null;
        }
    }
}

