/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class MaybeFromFuture<T>
extends Maybe<T> {
    final Future<? extends T> future;
    final long timeout;
    final TimeUnit unit;

    public MaybeFromFuture(Future<? extends T> future, long timeout, TimeUnit unit) {
        this.future = future;
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        Disposable d15 = Disposable.empty();
        observer.onSubscribe(d15);
        if (!d15.isDisposed()) {
            T v15;
            try {
                v15 = this.timeout <= 0L ? this.future.get() : this.future.get(this.timeout, this.unit);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                if (ex4 instanceof ExecutionException) {
                    ex4 = ex4.getCause();
                }
                Exceptions.throwIfFatal(ex4);
                if (!d15.isDisposed()) {
                    observer.onError(ex4);
                }
                return;
            }
            if (!d15.isDisposed()) {
                if (v15 == null) {
                    observer.onComplete();
                } else {
                    observer.onSuccess(v15);
                }
            }
        }
    }
}

