/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.mixed.ScalarXMapZHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableSwitchMapMaybe<T, R>
extends Observable<R> {
    final Observable<T> source;
    final Function<? super T, ? extends MaybeSource<? extends R>> mapper;
    final boolean delayErrors;

    public ObservableSwitchMapMaybe(Observable<T> source, Function<? super T, ? extends MaybeSource<? extends R>> mapper, boolean delayErrors) {
        this.source = source;
        this.mapper = mapper;
        this.delayErrors = delayErrors;
    }

    @Override
    protected void subscribeActual(Observer<? super R> observer) {
        if (!ScalarXMapZHelper.tryAsMaybe(this.source, this.mapper, observer)) {
            this.source.subscribe(new SwitchMapMaybeMainObserver<T, R>(observer, this.mapper, this.delayErrors));
        }
    }

    static final class SwitchMapMaybeMainObserver<T, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -5402190102429853762L;
        final Observer<? super R> downstream;
        final Function<? super T, ? extends MaybeSource<? extends R>> mapper;
        final boolean delayErrors;
        final AtomicThrowable errors;
        final AtomicReference<SwitchMapMaybeObserver<R>> inner;
        static final SwitchMapMaybeObserver<Object> INNER_DISPOSED = new SwitchMapMaybeObserver(null);
        Disposable upstream;
        volatile boolean done;
        volatile boolean cancelled;

        SwitchMapMaybeMainObserver(Observer<? super R> downstream, Function<? super T, ? extends MaybeSource<? extends R>> mapper, boolean delayErrors) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
            this.inner = new AtomicReference();
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            MaybeSource<R> ms4;
            SwitchMapMaybeObserver<R> current = this.inner.get();
            if (current != null) {
                current.dispose();
            }
            try {
                ms4 = Objects.requireNonNull(this.mapper.apply(t15), "The mapper returned a null MaybeSource");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.upstream.dispose();
                this.inner.getAndSet(INNER_DISPOSED);
                this.onError(ex4);
                return;
            }
            SwitchMapMaybeObserver observer = new SwitchMapMaybeObserver(this);
            while ((current = this.inner.get()) != INNER_DISPOSED) {
                if (!this.inner.compareAndSet(current, observer)) continue;
                ms4.subscribe(observer);
                break;
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (this.errors.tryAddThrowableOrReport(t15)) {
                if (!this.delayErrors) {
                    this.disposeInner();
                }
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void disposeInner() {
            SwitchMapMaybeObserver<Object> current = this.inner.getAndSet(INNER_DISPOSED);
            if (current != null && current != INNER_DISPOSED) {
                current.dispose();
            }
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.upstream.dispose();
            this.disposeInner();
            this.errors.tryTerminateAndReport();
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void innerError(SwitchMapMaybeObserver<R> sender, Throwable ex4) {
            if (this.inner.compareAndSet(sender, null)) {
                if (this.errors.tryAddThrowableOrReport(ex4)) {
                    if (!this.delayErrors) {
                        this.upstream.dispose();
                        this.disposeInner();
                    }
                    this.drain();
                }
            } else {
                RxJavaPlugins.onError(ex4);
            }
        }

        void innerComplete(SwitchMapMaybeObserver<R> sender) {
            if (this.inner.compareAndSet(sender, null)) {
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer<R> downstream = this.downstream;
            AtomicThrowable errors = this.errors;
            AtomicReference<SwitchMapMaybeObserver<R>> inner = this.inner;
            while (true) {
                boolean empty;
                if (this.cancelled) {
                    return;
                }
                if (errors.get() != null && !this.delayErrors) {
                    errors.tryTerminateConsumer(downstream);
                    return;
                }
                boolean d15 = this.done;
                SwitchMapMaybeObserver<R> current = inner.get();
                boolean bl4 = empty = current == null;
                if (d15 && empty) {
                    errors.tryTerminateConsumer(downstream);
                    return;
                }
                if (!empty && current.item != null) {
                    inner.compareAndSet(current, null);
                    downstream.onNext(current.item);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        static final class SwitchMapMaybeObserver<R>
        extends AtomicReference<Disposable>
        implements MaybeObserver<R> {
            private static final long serialVersionUID = 8042919737683345351L;
            final SwitchMapMaybeMainObserver<?, R> parent;
            volatile R item;

            SwitchMapMaybeObserver(SwitchMapMaybeMainObserver<?, R> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d15) {
                DisposableHelper.setOnce(this, d15);
            }

            @Override
            public void onSuccess(R t15) {
                this.item = t15;
                this.parent.drain();
            }

            @Override
            public void onError(Throwable e15) {
                this.parent.innerError(this, e15);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete(this);
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

