/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import java.util.Objects;

public final class SingleDefer<T>
extends Single<T> {
    final Supplier<? extends SingleSource<? extends T>> singleSupplier;

    public SingleDefer(Supplier<? extends SingleSource<? extends T>> singleSupplier) {
        this.singleSupplier = singleSupplier;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        SingleSource<? super T> next;
        try {
            next = Objects.requireNonNull(this.singleSupplier.get(), "The singleSupplier returned a null SingleSource");
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            EmptyDisposable.error(e15, observer);
            return;
        }
        next.subscribe(observer);
    }
}

