/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscribers;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.disposables.DisposableContainer;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.observers.LambdaConsumerIntrospection;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public final class DisposableAutoReleaseSubscriber<T>
extends AtomicReference<Subscription>
implements FlowableSubscriber<T>,
Disposable,
LambdaConsumerIntrospection {
    private static final long serialVersionUID = 8924480688481408726L;
    final AtomicReference<DisposableContainer> composite;
    final Consumer<? super T> onNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;

    public DisposableAutoReleaseSubscriber(DisposableContainer composite, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
        this.composite = new AtomicReference<DisposableContainer>(composite);
    }

    @Override
    public void onNext(T t15) {
        if (this.get() != SubscriptionHelper.CANCELLED) {
            try {
                this.onNext.accept(t15);
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                ((Subscription)this.get()).cancel();
                this.onError(e15);
            }
        }
    }

    @Override
    public void onError(Throwable t15) {
        if (this.get() != SubscriptionHelper.CANCELLED) {
            this.lazySet(SubscriptionHelper.CANCELLED);
            try {
                this.onError.accept(t15);
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                RxJavaPlugins.onError(new CompositeException(t15, e15));
            }
        } else {
            RxJavaPlugins.onError(t15);
        }
        this.removeSelf();
    }

    @Override
    public void onComplete() {
        if (this.get() != SubscriptionHelper.CANCELLED) {
            this.lazySet(SubscriptionHelper.CANCELLED);
            try {
                this.onComplete.run();
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                RxJavaPlugins.onError(e15);
            }
        }
        this.removeSelf();
    }

    @Override
    public void dispose() {
        SubscriptionHelper.cancel(this);
        this.removeSelf();
    }

    void removeSelf() {
        DisposableContainer c15 = this.composite.getAndSet(null);
        if (c15 != null) {
            c15.delete(this);
        }
    }

    @Override
    public boolean isDisposed() {
        return SubscriptionHelper.CANCELLED == this.get();
    }

    @Override
    public void onSubscribe(Subscription s15) {
        if (SubscriptionHelper.setOnce(this, s15)) {
            s15.request(Long.MAX_VALUE);
        }
    }

    @Override
    public boolean hasCustomOnError() {
        return this.onError != Functions.ON_ERROR_MISSING;
    }
}

