/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.clsp;

import jadx.core.clsp.ClspClass;
import jadx.core.clsp.ClspClassSource;
import jadx.core.clsp.ClspMethod;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.exceptions.DecodeException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClsSet {
    private static final Logger LOG = LoggerFactory.getLogger(ClsSet.class);
    private static final String CLST_EXTENSION = ".jcst";
    private static final String CLST_FILENAME = "core.jcst";
    private static final String CLST_PATH = "/clst/core.jcst";
    private static final String JADX_CLS_SET_HEADER = "jadx-cst";
    private static final int VERSION = 5;
    private static final String STRING_CHARSET = "US-ASCII";
    private static final ArgType[] EMPTY_ARGTYPE_ARRAY = new ArgType[0];
    private static final ArgType[] OBJECT_ARGTYPE_ARRAY = new ArgType[]{ArgType.OBJECT};
    private final RootNode root;
    private int androidApiLevel;
    private ClspClass[] classes;

    public ClsSet(RootNode root) {
        this.root = root;
    }

    public void loadFromClstFile() throws IOException, DecodeException {
        long startTime = System.currentTimeMillis();
        try (InputStream input = ClsSet.class.getResourceAsStream(CLST_PATH);){
            if (input == null) {
                throw new JadxRuntimeException("Can't load classpath file: /clst/core.jcst");
            }
            this.load(input);
        }
        if (LOG.isDebugEnabled()) {
            long time = System.currentTimeMillis() - startTime;
            int methodsCount = Stream.of(this.classes).mapToInt(clspClass -> clspClass.getMethodsMap().size()).sum();
            LOG.debug("Clst file loaded in {}ms, android api: {}, classes: {}, methods: {}", time, this.androidApiLevel, this.classes.length, methodsCount);
        }
    }

    public void loadFrom(RootNode root) {
        List<ClassNode> list2 = root.getClasses(true);
        HashMap<String, ClspClass> names = new HashMap<String, ClspClass>(list2.size());
        int k15 = 0;
        for (ClassNode cls : list2) {
            ArgType clsType = cls.getClassInfo().getType();
            String clsRawName = clsType.getObject();
            cls.load();
            ClspClassSource source = ClsSet.getClspClassSource(cls);
            ClspClass nClass = new ClspClass(clsType, k15, cls.getAccessFlags().rawValue(), source);
            if (names.put(clsRawName, nClass) != null) {
                throw new JadxRuntimeException("Duplicate class: " + clsRawName);
            }
            ++k15;
            nClass.setTypeParameters(cls.getGenericTypeParameters());
            nClass.setMethods(this.getMethodsDetails(cls));
        }
        this.classes = new ClspClass[k15];
        k15 = 0;
        for (ClassNode cls : list2) {
            ClspClass nClass = ClsSet.getCls(cls, names);
            if (nClass == null) {
                throw new JadxRuntimeException("Missing class: " + String.valueOf(cls));
            }
            nClass.setParents(ClsSet.makeParentsArray(cls));
            this.classes[k15] = nClass;
            ++k15;
        }
    }

    private static ClspClassSource getClspClassSource(ClassNode cls) {
        int idx;
        String inputFileName = cls.getClsData().getInputFileName();
        String sourceFile = inputFileName.substring(0, idx = inputFileName.indexOf(58));
        ClspClassSource source = ClspClassSource.getClspClassSource(sourceFile);
        if (source == ClspClassSource.APP) {
            throw new JadxRuntimeException("Unexpected input file: " + inputFileName);
        }
        return source;
    }

    private List<ClspMethod> getMethodsDetails(ClassNode cls) {
        List<MethodNode> methodsList = cls.getMethods();
        ArrayList<ClspMethod> methods2 = new ArrayList<ClspMethod>(methodsList.size());
        for (MethodNode mth : methodsList) {
            this.processMethodDetails(mth, methods2);
        }
        return methods2;
    }

    private void processMethodDetails(MethodNode mth, List<ClspMethod> methods2) {
        AccessInfo accessFlags = mth.getAccessFlags();
        if (accessFlags.isPrivate() || accessFlags.isSynthetic() || accessFlags.isBridge()) {
            return;
        }
        ClspMethod clspMethod = new ClspMethod(mth.getMethodInfo(), mth.getArgTypes(), mth.getReturnType(), mth.getTypeParameters(), mth.getThrows(), accessFlags.rawValue());
        methods2.add(clspMethod);
    }

    public static ArgType[] makeParentsArray(ClassNode cls) {
        ArgType superClass = cls.getSuperClass();
        if (superClass == null) {
            return EMPTY_ARGTYPE_ARRAY;
        }
        int interfacesCount = cls.getInterfaces().size();
        if (interfacesCount == 0 && superClass == ArgType.OBJECT) {
            return OBJECT_ARGTYPE_ARRAY;
        }
        ArgType[] parents = new ArgType[1 + interfacesCount];
        parents[0] = superClass;
        int k15 = 1;
        Iterator<ArgType> iterator2 = cls.getInterfaces().iterator();
        while (iterator2.hasNext()) {
            ArgType iface;
            parents[k15] = iface = iterator2.next();
            ++k15;
        }
        return parents;
    }

    private static ClspClass getCls(ClassNode cls, Map<String, ClspClass> names) {
        return ClsSet.getCls(cls.getRawName(), names);
    }

    private static ClspClass getCls(ArgType clsType, Map<String, ClspClass> names) {
        return ClsSet.getCls(clsType.getObject(), names);
    }

    private static ClspClass getCls(String fullName, Map<String, ClspClass> names) {
        ClspClass cls = names.get(fullName);
        if (cls == null) {
            LOG.debug("Class not found: {}", (Object)fullName);
        }
        return cls;
    }

    public void save(Path path) throws IOException {
        FileUtils.makeDirsForFile(path);
        String outputName = path.getFileName().toString();
        if (outputName.endsWith(CLST_EXTENSION)) {
            try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                this.save(outputStream);
            }
        } else {
            throw new JadxRuntimeException("Unknown file format: " + outputName);
        }
    }

    private void save(OutputStream output) throws IOException {
        DataOutputStream out = new DataOutputStream(output);
        out.writeBytes(JADX_CLS_SET_HEADER);
        out.writeByte(5);
        out.writeInt(this.androidApiLevel);
        HashMap<String, ClspClass> names = new HashMap<String, ClspClass>(this.classes.length);
        out.writeInt(this.classes.length);
        for (ClspClass cls : this.classes) {
            out.writeInt(cls.getAccFlags());
            ClsSet.writeUnsignedByte(out, cls.getSource().ordinal());
            String clsName = cls.getName();
            ClsSet.writeString(out, clsName);
            names.put(clsName, cls);
        }
        for (ClspClass cls : this.classes) {
            ClsSet.writeArgTypesArray(out, cls.getParents(), names);
            ClsSet.writeArgTypesList(out, cls.getTypeParameters(), names);
            List<ClspMethod> methods2 = cls.getSortedMethodsList();
            out.writeShort(methods2.size());
            for (ClspMethod method : methods2) {
                ClsSet.writeMethod(out, method, names);
            }
        }
        int methodsCount = Stream.of(this.classes).mapToInt(c15 -> c15.getMethodsMap().size()).sum();
        LOG.info("Classes: {}, methods: {}, file size: {} bytes", this.classes.length, methodsCount, out.size());
    }

    private static void writeMethod(DataOutputStream out, ClspMethod method, Map<String, ClspClass> names) throws IOException {
        MethodInfo methodInfo = method.getMethodInfo();
        ClsSet.writeString(out, methodInfo.getName());
        ClsSet.writeArgTypesList(out, methodInfo.getArgumentsTypes(), names);
        ClsSet.writeArgType(out, methodInfo.getReturnType(), names);
        ClsSet.writeArgTypesList(out, method.containsGenericArgs() ? method.getArgTypes() : Collections.emptyList(), names);
        ClsSet.writeArgType(out, method.getReturnType(), names);
        ClsSet.writeArgTypesList(out, method.getTypeParameters(), names);
        out.writeInt(method.getRawAccessFlags());
        ClsSet.writeArgTypesList(out, method.getThrows(), names);
    }

    private static void writeArgTypesList(DataOutputStream out, List<ArgType> list2, Map<String, ClspClass> names) throws IOException {
        int size = list2.size();
        ClsSet.writeUnsignedByte(out, size);
        if (size != 0) {
            for (ArgType type : list2) {
                ClsSet.writeArgType(out, type, names);
            }
        }
    }

    private static void writeArgTypesArray(DataOutputStream out, @Nullable ArgType[] arr, Map<String, ClspClass> names) throws IOException {
        if (arr == null) {
            out.writeByte(-1);
            return;
        }
        if (arr == OBJECT_ARGTYPE_ARRAY) {
            out.writeByte(-2);
            return;
        }
        int size = arr.length;
        out.writeByte(size);
        if (size != 0) {
            for (ArgType type : arr) {
                ClsSet.writeArgType(out, type, names);
            }
        }
    }

    private static void writeArgType(DataOutputStream out, ArgType argType, Map<String, ClspClass> names) throws IOException {
        if (argType == null) {
            out.writeByte(-1);
            return;
        }
        if (argType.isPrimitive()) {
            out.writeByte(TypeEnum.PRIMITIVE.ordinal());
            out.writeByte(argType.getPrimitiveType().getShortName().charAt(0));
        } else if (argType.getOuterType() != null) {
            out.writeByte(TypeEnum.OUTER_GENERIC.ordinal());
            ClsSet.writeArgType(out, argType.getOuterType(), names);
            ClsSet.writeArgType(out, argType.getInnerType(), names);
        } else if (argType.getWildcardType() != null) {
            out.writeByte(TypeEnum.WILDCARD.ordinal());
            ArgType.WildcardBound bound = argType.getWildcardBound();
            out.writeByte(bound.getNum());
            if (bound != ArgType.WildcardBound.UNBOUND) {
                ClsSet.writeArgType(out, argType.getWildcardType(), names);
            }
        } else if (argType.isGeneric()) {
            out.writeByte(TypeEnum.GENERIC.ordinal());
            out.writeInt(ClsSet.getCls(argType, names).getId());
            ClsSet.writeArgTypesList(out, argType.getGenericTypes(), names);
        } else if (argType.isGenericType()) {
            out.writeByte(TypeEnum.GENERIC_TYPE_VARIABLE.ordinal());
            ClsSet.writeString(out, argType.getObject());
            ClsSet.writeArgTypesList(out, argType.getExtendTypes(), names);
        } else if (argType.isObject()) {
            out.writeByte(TypeEnum.OBJECT.ordinal());
            out.writeInt(ClsSet.getCls(argType, names).getId());
        } else if (argType.isArray()) {
            out.writeByte(TypeEnum.ARRAY.ordinal());
            ClsSet.writeArgType(out, argType.getArrayElement(), names);
        } else {
            throw new JadxRuntimeException("Cannot save type: " + String.valueOf(argType));
        }
    }

    private void load(InputStream input) throws IOException, DecodeException {
        try (DataInputStream in4 = new DataInputStream(new BufferedInputStream(input));){
            int i15;
            byte[] header = new byte[JADX_CLS_SET_HEADER.length()];
            int readHeaderLength = in4.read(header);
            if (readHeaderLength != JADX_CLS_SET_HEADER.length() || !JADX_CLS_SET_HEADER.equals(new String(header, STRING_CHARSET))) {
                throw new DecodeException("Wrong jadx class set header");
            }
            byte version = in4.readByte();
            if (version != 5) {
                throw new DecodeException("Wrong jadx class set version, got: " + version + ", expect: 5");
            }
            this.androidApiLevel = in4.readInt();
            int clsCount = in4.readInt();
            this.classes = new ClspClass[clsCount];
            for (i15 = 0; i15 < clsCount; ++i15) {
                int accFlags = in4.readInt();
                ClspClassSource clsSource = ClsSet.readClsSource(in4);
                String name = ClsSet.readString(in4);
                this.classes[i15] = new ClspClass(ArgType.object(name), i15, accFlags, clsSource);
            }
            for (i15 = 0; i15 < clsCount; ++i15) {
                ClspClass nClass = this.classes[i15];
                ClassInfo clsInfo = ClassInfo.fromType(this.root, nClass.getClsType());
                nClass.setParents(this.readArgTypesArray(in4));
                nClass.setTypeParameters(this.readArgTypesList(in4));
                nClass.setMethods(this.readClsMethods(in4, clsInfo));
            }
        }
    }

    private static ClspClassSource readClsSource(DataInputStream in4) throws IOException, DecodeException {
        int source = ClsSet.readUnsignedByte(in4);
        ClspClassSource[] clspClassSources = ClspClassSource.values();
        if (source < 0 || source > clspClassSources.length) {
            throw new DecodeException("Wrong jadx source identifier: " + source);
        }
        return clspClassSources[source];
    }

    private List<ClspMethod> readClsMethods(DataInputStream in4, ClassInfo clsInfo) throws IOException {
        int mCount = in4.readShort();
        ArrayList<ClspMethod> methods2 = new ArrayList<ClspMethod>(mCount);
        for (int j15 = 0; j15 < mCount; ++j15) {
            methods2.add(this.readMethod(in4, clsInfo));
        }
        return methods2;
    }

    private ClspMethod readMethod(DataInputStream in4, ClassInfo clsInfo) throws IOException {
        ArgType genericRetType;
        String name = ClsSet.readString(in4);
        List<ArgType> argTypes = this.readArgTypesList(in4);
        ArgType retType = this.readArgType(in4);
        List<ArgType> genericArgTypes = this.readArgTypesList(in4);
        if (genericArgTypes.isEmpty() || Objects.equals(genericArgTypes, argTypes)) {
            genericArgTypes = argTypes;
        }
        if (Objects.equals(genericRetType = this.readArgType(in4), retType)) {
            genericRetType = retType;
        }
        List<ArgType> typeParameters = this.readArgTypesList(in4);
        int accFlags = in4.readInt();
        List<ArgType> throwList = this.readArgTypesList(in4);
        MethodInfo methodInfo = MethodInfo.fromDetails(this.root, clsInfo, name, argTypes, retType);
        return new ClspMethod(methodInfo, genericArgTypes, genericRetType, typeParameters, throwList, accFlags);
    }

    private List<ArgType> readArgTypesList(DataInputStream in4) throws IOException {
        int count = in4.readByte();
        if (count == 0) {
            return Collections.emptyList();
        }
        ArrayList<ArgType> list2 = new ArrayList<ArgType>(count);
        for (int i15 = 0; i15 < count; ++i15) {
            list2.add(this.readArgType(in4));
        }
        return list2;
    }

    @Nullable
    private ArgType[] readArgTypesArray(DataInputStream in4) throws IOException {
        int count = in4.readByte();
        switch (count) {
            case -1: {
                return null;
            }
            case -2: {
                return OBJECT_ARGTYPE_ARRAY;
            }
            case 0: {
                return EMPTY_ARGTYPE_ARRAY;
            }
        }
        ArgType[] arr = new ArgType[count];
        for (int i15 = 0; i15 < count; ++i15) {
            arr[i15] = this.readArgType(in4);
        }
        return arr;
    }

    private ArgType readArgType(DataInputStream in4) throws IOException {
        byte ordinal = in4.readByte();
        if (ordinal == -1) {
            return null;
        }
        switch (TypeEnum.values()[ordinal]) {
            case WILDCARD: {
                ArgType.WildcardBound bound = ArgType.WildcardBound.getByNum(in4.readByte());
                if (bound == ArgType.WildcardBound.UNBOUND) {
                    return ArgType.WILDCARD;
                }
                ArgType objType = this.readArgType(in4);
                return ArgType.wildcard(objType, bound);
            }
            case OUTER_GENERIC: {
                ArgType outerType = this.readArgType(in4);
                ArgType innerType = this.readArgType(in4);
                return ArgType.outerGeneric(outerType, innerType);
            }
            case GENERIC: {
                ArgType clsType = this.classes[in4.readInt()].getClsType();
                return ArgType.generic(clsType, this.readArgTypesList(in4));
            }
            case GENERIC_TYPE_VARIABLE: {
                String typeVar = ClsSet.readString(in4);
                List<ArgType> extendTypes = this.readArgTypesList(in4);
                return ArgType.genericType(typeVar, extendTypes);
            }
            case OBJECT: {
                return this.classes[in4.readInt()].getClsType();
            }
            case ARRAY: {
                return ArgType.array(Objects.requireNonNull(this.readArgType(in4)));
            }
            case PRIMITIVE: {
                char shortName = (char)in4.readByte();
                return ArgType.parse(shortName);
            }
        }
        throw new JadxRuntimeException("Unsupported Arg Type: " + ordinal);
    }

    private static void writeString(DataOutputStream out, String name) throws IOException {
        byte[] bytes = name.getBytes(STRING_CHARSET);
        int len = bytes.length;
        if (len >= 255) {
            throw new JadxRuntimeException("String is too long: " + name);
        }
        ClsSet.writeUnsignedByte(out, bytes.length);
        out.write(bytes);
    }

    private static String readString(DataInputStream in4) throws IOException {
        int len = ClsSet.readUnsignedByte(in4);
        return ClsSet.readString(in4, len);
    }

    private static String readString(DataInputStream in4, int len) throws IOException {
        int res;
        byte[] bytes = new byte[len];
        for (int count = in4.read(bytes); count != len; count += res) {
            res = in4.read(bytes, count, len - count);
            if (res != -1) continue;
            throw new IOException("String read error");
        }
        return new String(bytes, STRING_CHARSET);
    }

    private static void writeUnsignedByte(DataOutputStream out, int value) throws IOException {
        if (value < 0 || value >= 255) {
            throw new JadxRuntimeException("Unsigned byte value is too big: " + value);
        }
        out.writeByte(value);
    }

    private static int readUnsignedByte(DataInputStream in4) throws IOException {
        return in4.readByte() & 0xFF;
    }

    public int getClassesCount() {
        return this.classes.length;
    }

    public void addToMap(Map<String, ClspClass> nameMap) {
        for (ClspClass cls : this.classes) {
            nameMap.put(cls.getName(), cls);
        }
    }

    public int getAndroidApiLevel() {
        return this.androidApiLevel;
    }

    public void setAndroidApiLevel(int androidApiLevel) {
        this.androidApiLevel = androidApiLevel;
    }

    private static enum TypeEnum {
        WILDCARD,
        GENERIC,
        GENERIC_TYPE_VARIABLE,
        OUTER_GENERIC,
        OBJECT,
        ARRAY,
        PRIMITIVE;

    }
}

