/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.clsp;

import jadx.api.plugins.input.data.AccessFlags;
import jadx.core.clsp.ClspClassSource;
import jadx.core.clsp.ClspMethod;
import jadx.core.dex.instructions.args.ArgType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClspClass {
    private final ArgType clsType;
    private final int id;
    private final int accFlags;
    private ArgType[] parents;
    private Map<String, ClspMethod> methodsMap = Collections.emptyMap();
    private List<ArgType> typeParameters = Collections.emptyList();
    private final ClspClassSource source;

    public ClspClass(ArgType clsType, int id5, int accFlags, ClspClassSource source) {
        this.clsType = clsType;
        this.id = id5;
        this.accFlags = accFlags;
        this.source = source;
    }

    public String getName() {
        return this.clsType.getObject();
    }

    public ArgType getClsType() {
        return this.clsType;
    }

    public int getId() {
        return this.id;
    }

    public int getAccFlags() {
        return this.accFlags;
    }

    public boolean isInterface() {
        return AccessFlags.hasFlag(this.accFlags, 512);
    }

    public boolean hasAccFlag(int flags) {
        return AccessFlags.hasFlag(this.accFlags, flags);
    }

    public ArgType[] getParents() {
        return this.parents;
    }

    public void setParents(ArgType[] parents) {
        this.parents = parents;
    }

    public Map<String, ClspMethod> getMethodsMap() {
        return this.methodsMap;
    }

    public List<ClspMethod> getSortedMethodsList() {
        ArrayList<ClspMethod> list2 = new ArrayList<ClspMethod>(this.methodsMap.size());
        list2.addAll(this.methodsMap.values());
        Collections.sort(list2);
        return list2;
    }

    public void setMethodsMap(Map<String, ClspMethod> methodsMap) {
        this.methodsMap = Objects.requireNonNull(methodsMap);
    }

    public void setMethods(List<ClspMethod> methods2) {
        HashMap<String, ClspMethod> map = new HashMap<String, ClspMethod>(methods2.size());
        for (ClspMethod mth : methods2) {
            map.put(mth.getMethodInfo().getShortId(), mth);
        }
        this.setMethodsMap(map);
    }

    public List<ArgType> getTypeParameters() {
        return this.typeParameters;
    }

    public void setTypeParameters(List<ArgType> typeParameters) {
        this.typeParameters = typeParameters;
    }

    public ClspClassSource getSource() {
        return this.source;
    }

    public int hashCode() {
        return this.clsType.hashCode();
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (o15 == null || this.getClass() != o15.getClass()) {
            return false;
        }
        ClspClass nClass = (ClspClass)o15;
        return this.clsType.equals(nClass.clsType);
    }

    public String toString() {
        return this.clsType.toString();
    }
}

