/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.core.dex.instructions.args.ArgType;

public enum PrimitiveType {
    BOOLEAN("Z", "boolean", ArgType.object("java.lang.Boolean")),
    CHAR("C", "char", ArgType.object("java.lang.Character")),
    BYTE("B", "byte", ArgType.object("java.lang.Byte")),
    SHORT("S", "short", ArgType.object("java.lang.Short")),
    INT("I", "int", ArgType.object("java.lang.Integer")),
    FLOAT("F", "float", ArgType.object("java.lang.Float")),
    LONG("J", "long", ArgType.object("java.lang.Long")),
    DOUBLE("D", "double", ArgType.object("java.lang.Double")),
    OBJECT("L", "OBJECT", ArgType.OBJECT),
    ARRAY("[", "ARRAY", ArgType.OBJECT_ARRAY),
    VOID("V", "void", ArgType.object("java.lang.Void"));

    private final String shortName;
    private final String longName;
    private final ArgType boxType;

    private PrimitiveType(String shortName, String longName, ArgType boxType) {
        this.shortName = shortName;
        this.longName = longName;
        this.boxType = boxType;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public ArgType getBoxType() {
        return this.boxType;
    }

    public String toString() {
        return this.longName;
    }

    public boolean isObjectOrArray() {
        return this == OBJECT || this == ARRAY;
    }
}

