/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.nodes.CodeFeaturesAttr;
import jadx.core.dex.instructions.FilledNewArrayNode;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.NewArrayNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IFieldInfoRef;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.ModVisitor;
import jadx.core.dex.visitors.shrink.CodeShrinkVisitor;
import jadx.core.utils.InsnList;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

@JadxVisitor(name="ReplaceNewArray", desc="Replace new-array and sequence of array-put to new filled-array instruction", runAfter={CodeShrinkVisitor.class})
public class ReplaceNewArray
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) throws JadxException {
        block4: {
            if (!CodeFeaturesAttr.contains(mth, CodeFeaturesAttr.CodeFeature.NEW_ARRAY)) {
                return;
            }
            InsnRemover remover = new InsnRemover(mth);
            int k15 = 0;
            do {
                boolean changed = false;
                for (BlockNode block : mth.getBasicBlocks()) {
                    List<InsnNode> insnList = block.getInstructions();
                    int size = insnList.size();
                    for (int i15 = 0; i15 < size; ++i15) {
                        changed |= ReplaceNewArray.processInsn(mth, insnList, i15, remover);
                    }
                    remover.performForBlock(block);
                }
                if (!changed) break block4;
                CodeShrinkVisitor.shrinkMethod(mth);
            } while (k15++ <= 100);
            mth.addWarnComment("Reached limit for ReplaceNewArray iterations");
        }
    }

    private static boolean processInsn(MethodNode mth, List<InsnNode> instructions, int i15, InsnRemover remover) {
        InsnNode insn = instructions.get(i15);
        if (insn.getType() == InsnType.NEW_ARRAY && !insn.contains(AFlag.REMOVE)) {
            return ReplaceNewArray.processNewArray(mth, (NewArrayNode)insn, instructions, remover);
        }
        return false;
    }

    private static boolean processNewArray(MethodNode mth, NewArrayNode newArrayInsn, List<InsnNode> instructions, InsnRemover remover) {
        int idx;
        Object arrayLenConst = InsnUtils.getConstValueByArg(mth.root(), newArrayInsn.getArg(0));
        if (!(arrayLenConst instanceof LiteralArg)) {
            return false;
        }
        int len = (int)((LiteralArg)arrayLenConst).getLiteral();
        if (len == 0) {
            return false;
        }
        ArgType arrType = newArrayInsn.getArrayType();
        ArgType elemType = arrType.getArrayElement();
        boolean allowMissingKeys = arrType.getArrayDimension() == 1 && elemType.isPrimitive();
        int minLen = allowMissingKeys ? len / 2 : len;
        RegisterArg arrArg = newArrayInsn.getResult();
        List<RegisterArg> useList = arrArg.getSVar().getUseList();
        if (useList.size() < minLen) {
            return false;
        }
        boolean foundPut = false;
        for (RegisterArg registerArg : useList) {
            InsnNode parentInsn = registerArg.getParentInsn();
            if (parentInsn == null || parentInsn.getType() != InsnType.APUT) continue;
            foundPut = true;
            break;
        }
        if (!foundPut) {
            return false;
        }
        TreeMap<Long, InsnNode> arrPuts = new TreeMap<Long, InsnNode>();
        InsnNode firstNotAPutUsage = null;
        for (RegisterArg registerArg : useList) {
            InsnNode parentInsn = registerArg.getParentInsn();
            if (parentInsn == null || parentInsn.getType() != InsnType.APUT || !arrArg.sameRegAndSVar(parentInsn.getArg(0))) {
                if (firstNotAPutUsage != null) continue;
                firstNotAPutUsage = parentInsn;
                continue;
            }
            Iterator constVal = InsnUtils.getConstValueByArg(mth.root(), parentInsn.getArg(1));
            if (!(constVal instanceof LiteralArg)) {
                return false;
            }
            long index = ((LiteralArg)((Object)constVal)).getLiteral();
            if (index >= (long)len) {
                return false;
            }
            if (arrPuts.containsKey(index)) break;
            arrPuts.put(index, parentInsn);
        }
        if (arrPuts.size() < minLen) {
            return false;
        }
        if (!ReplaceNewArray.verifyPutInsns(arrArg, instructions, arrPuts)) {
            return false;
        }
        FilledNewArrayNode filledArr = new FilledNewArrayNode(elemType, len);
        filledArr.setResult(arrArg.duplicate());
        filledArr.copyAttributesFrom(newArrayInsn);
        filledArr.inheritMetadata(newArrayInsn);
        filledArr.setOffset(newArrayInsn.getOffset());
        long prevIndex = -1L;
        for (Map.Entry entry : arrPuts.entrySet()) {
            long index = (Long)entry.getKey();
            if (index != prevIndex) {
                for (long i15 = prevIndex + 1L; i15 < index; ++i15) {
                    filledArr.addArg(InsnArg.lit(0L, elemType));
                }
            }
            InsnNode put = (InsnNode)entry.getValue();
            filledArr.addArg(ReplaceNewArray.replaceConstInArg(mth, put.getArg(2)));
            remover.addAndUnbind(put);
            prevIndex = index;
        }
        for (long i16 = prevIndex + 1L; i16 < (long)len; ++i16) {
            filledArr.addArg(InsnArg.lit(0L, elemType));
        }
        remover.addAndUnbind(newArrayInsn);
        InsnNode lastPut = (InsnNode)arrPuts.get(arrPuts.lastKey());
        int newInsnPos = InsnList.getIndex(instructions, lastPut);
        if (firstNotAPutUsage != null && (idx = InsnList.getIndex(instructions, firstNotAPutUsage)) != -1) {
            newInsnPos = Math.min(idx, newInsnPos);
        }
        instructions.add(newInsnPos, filledArr);
        return true;
    }

    private static boolean verifyPutInsns(RegisterArg arrReg, List<InsnNode> insnList, SortedMap<Long, InsnNode> arrPuts) {
        ArrayList<InsnNode> puts = new ArrayList<InsnNode>(arrPuts.values());
        int putsCount = puts.size();
        if (insnList.size() < putsCount) {
            return false;
        }
        Set insnSet = Collections.newSetFromMap(new IdentityHashMap());
        insnSet.addAll(insnList);
        if (!insnSet.containsAll(puts)) {
            return false;
        }
        for (InsnNode put : puts) {
            InsnArg putArg = put.getArg(2);
            if (!putArg.isUseVar(arrReg)) continue;
            return false;
        }
        return true;
    }

    private static InsnArg replaceConstInArg(MethodNode mth, InsnArg valueArg) {
        IFieldInfoRef f15;
        if (valueArg.isLiteral() && (f15 = mth.getParentClass().getConstFieldByLiteralArg((LiteralArg)valueArg)) != null) {
            IndexInsnNode fGet = new IndexInsnNode(InsnType.SGET, f15.getFieldInfo(), 0);
            InsnArg arg = InsnArg.wrapArg(fGet);
            ModVisitor.addFieldUsage(f15, mth);
            return arg;
        }
        return valueArg.duplicate();
    }
}

