/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.ssa;

import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.BitSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveVarAnalysis {
    private static final Logger LOG = LoggerFactory.getLogger(LiveVarAnalysis.class);
    private final MethodNode mth;
    private BitSet[] uses;
    private BitSet[] defs;
    private BitSet[] liveIn;
    private BitSet[] assignBlocks;

    public LiveVarAnalysis(MethodNode mth) {
        this.mth = mth;
    }

    public void runAnalysis() {
        int bbCount = this.mth.getBasicBlocks().size();
        int regsCount = this.mth.getRegsCount();
        this.uses = LiveVarAnalysis.initBitSetArray(bbCount, regsCount);
        this.defs = LiveVarAnalysis.initBitSetArray(bbCount, regsCount);
        this.assignBlocks = LiveVarAnalysis.initBitSetArray(regsCount, bbCount);
        this.fillBasicBlockInfo();
        this.processLiveInfo();
    }

    public BitSet getAssignBlocks(int regNum) {
        return this.assignBlocks[regNum];
    }

    public boolean isLive(int blockId, int regNum) {
        if (blockId >= this.liveIn.length) {
            LOG.warn("LiveVarAnalysis: out of bounds block: {}, max: {}", (Object)blockId, (Object)this.liveIn.length);
            return false;
        }
        return this.liveIn[blockId].get(regNum);
    }

    public boolean isLive(BlockNode block, int regNum) {
        return this.isLive(block.getId(), regNum);
    }

    private void fillBasicBlockInfo() {
        for (BlockNode block : this.mth.getBasicBlocks()) {
            int blockId = block.getId();
            BitSet gen = this.uses[blockId];
            BitSet kill = this.defs[blockId];
            for (InsnNode insn : block.getInstructions()) {
                for (InsnArg arg : insn.getArguments()) {
                    int regNum;
                    if (!arg.isRegister() || kill.get(regNum = ((RegisterArg)arg).getRegNum())) continue;
                    gen.set(regNum);
                }
                RegisterArg result = insn.getResult();
                if (result == null) continue;
                int regNum = result.getRegNum();
                kill.set(regNum);
                this.assignBlocks[regNum].set(blockId);
            }
        }
    }

    private void processLiveInfo() {
        boolean changed;
        int bbCount = this.mth.getBasicBlocks().size();
        int regsCount = this.mth.getRegsCount();
        BitSet[] liveInBlocks = LiveVarAnalysis.initBitSetArray(bbCount, regsCount);
        List<BlockNode> blocks = this.mth.getBasicBlocks();
        int blocksCount = blocks.size();
        int iterationsLimit = blocksCount * 10;
        int k15 = 0;
        do {
            changed = false;
            for (BlockNode block : blocks) {
                int blockId = block.getId();
                BitSet prevIn = liveInBlocks[blockId];
                BitSet newIn = new BitSet(regsCount);
                for (BlockNode successor : block.getSuccessors()) {
                    newIn.or(liveInBlocks[successor.getId()]);
                }
                newIn.andNot(this.defs[blockId]);
                newIn.or(this.uses[blockId]);
                if (prevIn.equals(newIn)) continue;
                changed = true;
                liveInBlocks[blockId] = newIn;
            }
            if (k15++ <= iterationsLimit) continue;
            throw new JadxRuntimeException("Live variable analysis reach iterations limit, blocks count: " + blocksCount);
        } while (changed);
        this.liveIn = liveInBlocks;
    }

    private static BitSet[] initBitSetArray(int length, int bitsCount) {
        BitSet[] array = new BitSet[length];
        for (int i15 = 0; i15 < length; ++i15) {
            array[i15] = new BitSet(bitsCount);
        }
        return array;
    }
}

