/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.cache.usage;

import jadx.api.usage.IUsageInfoVisitor;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.Utils;
import jadx.gui.cache.usage.MthRef;
import jadx.gui.cache.usage.RawUsageData;
import java.util.List;

final class CollectUsageData
implements IUsageInfoVisitor {
    private final RawUsageData data;

    public CollectUsageData(RawUsageData usageData) {
        this.data = usageData;
    }

    @Override
    public void visitClassDeps(ClassNode cls, List<ClassNode> deps) {
        this.data.getClassData(cls).setClsDeps(this.clsNodesRef(deps));
    }

    @Override
    public void visitClassUsage(ClassNode cls, List<ClassNode> usage) {
        this.data.getClassData(cls).setClsUsage(this.clsNodesRef(usage));
    }

    @Override
    public void visitClassUseInMethods(ClassNode cls, List<MethodNode> methods2) {
        this.data.getClassData(cls).setClsUseInMth(this.mthNodesRef(methods2));
    }

    @Override
    public void visitFieldsUsage(FieldNode fld, List<MethodNode> methods2) {
        this.data.getFieldData(fld).setUsage(this.mthNodesRef(methods2));
    }

    @Override
    public void visitMethodsUsage(MethodNode mth, List<MethodNode> methods2) {
        this.data.getMethodData(mth).setUsage(this.mthNodesRef(methods2));
    }

    @Override
    public void visitComplete() {
        this.data.collectClassesWithoutData();
    }

    private List<String> clsNodesRef(List<ClassNode> usage) {
        return Utils.collectionMap(usage, ClassNode::getRawName);
    }

    private List<MthRef> mthNodesRef(List<MethodNode> methods2) {
        return Utils.collectionMap(methods2, m15 -> this.data.getMethodData((MethodNode)m15).getMthRef());
    }
}

