/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.device.debugger.smali;

import jadx.api.ICodeInfo;
import jadx.api.plugins.input.data.AccessFlags;
import jadx.api.plugins.input.data.AccessFlagsScope;
import jadx.api.plugins.input.data.ICatch;
import jadx.api.plugins.input.data.IClassData;
import jadx.api.plugins.input.data.ICodeReader;
import jadx.api.plugins.input.data.IDebugInfo;
import jadx.api.plugins.input.data.IFieldData;
import jadx.api.plugins.input.data.ILocalVar;
import jadx.api.plugins.input.data.IMethodData;
import jadx.api.plugins.input.data.IMethodRef;
import jadx.api.plugins.input.data.ITry;
import jadx.api.plugins.input.data.annotations.AnnotationVisibility;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.api.plugins.input.data.attributes.types.AnnotationsAttr;
import jadx.api.plugins.input.insns.InsnData;
import jadx.api.plugins.input.insns.InsnIndexType;
import jadx.api.plugins.input.insns.Opcode;
import jadx.api.plugins.input.insns.custom.ISwitchPayload;
import jadx.core.dex.attributes.AttributeStorage;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnDecoder;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.StringUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.device.debugger.smali.SmaliMethodNode;
import jadx.gui.device.debugger.smali.SmaliRegister;
import jadx.gui.device.debugger.smali.SmaliWriter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Smali {
    private static final Logger LOG = LoggerFactory.getLogger(Smali.class);
    private static SmaliInsnDecoder insnDecoder = null;
    private ICodeInfo codeInfo;
    private final Map<String, SmaliMethodNode> insnMap = new HashMap<String, SmaliMethodNode>();
    private final boolean printFileOffset = true;
    private final boolean printBytecode = true;
    private boolean isJavaBytecode;
    private static final int CODE_OFFSET_COLUMN_WIDTH = 4;
    private static final int BYTECODE_COLUMN_WIDTH = 23;
    private static final String FMT_BYTECODE_COL = "%-20s";
    private static final int INSN_COL_WIDTH = "const-method-handle".length();
    private static final String FMT_INSN_COL = "%-" + INSN_COL_WIDTH + "s";
    private static final String FMT_FILE_OFFSET = "%08x:";
    private static final String FMT_CODE_OFFSET = "%04x:";
    private static final String FMT_TARGET_OFFSET = "%04x";
    private static final String FMT_GOTO = ":goto_%04x";
    private static final String FMT_COND = ":cond_%04x";
    private static final String FMT_DATA = ":array_%04x";
    private static final String FMT_P_SWITCH = ":p_switch_%04x";
    private static final String FMT_S_SWITCH = ":s_switch_%04x";
    private static final String FMT_P_SWITCH_CASE = ":p_case_%04x";
    private static final String FMT_S_SWITCH_CASE = ":s_case_%04x";
    private static final String FMT_TRY_TAG = "try_%04x:";
    private static final String FMT_TRY_END_TAG = "try_end_%04x:";
    private static final String FMT_CATCH_TAG = "catch_%04x:";
    private static final String FMT_CATCH_ALL_TAG = "catch_all_%04x:";
    private static final String FMT_GOTO_TAG = "goto_%04x:";
    private static final String FMT_COND_TAG = "cond_%04x:";
    private static final String FMT_DATA_TAG = "array_%04x:";
    private static final String FMT_P_SWITCH_TAG = "p_switch_%04x:";
    private static final String FMT_S_SWITCH_TAG = "s_switch_%04x:";
    private static final String FMT_P_SWITCH_CASE_TAG = "p_case_%04x:";
    private static final String FMT_S_SWITCH_CASE_TAG = "s_case_%04x:";

    private Smali() {
    }

    public static Smali disassemble(ClassNode cls) {
        cls = cls.getTopParentClass();
        SmaliWriter code = new SmaliWriter(cls);
        Smali smali = new Smali();
        smali.isJavaBytecode = cls.getInputFileName().endsWith(".class");
        smali.writeClass(code, cls);
        smali.codeInfo = code.finish();
        return smali;
    }

    public String getCode() {
        return this.codeInfo.getCodeStr();
    }

    public int getMethodDefPos(String mthFullRawID) {
        SmaliMethodNode info = this.insnMap.get(mthFullRawID);
        if (info != null) {
            return info.getDefPos();
        }
        return -1;
    }

    public int getRegCount(String mthFullRawID) {
        SmaliMethodNode info = this.insnMap.get(mthFullRawID);
        if (info != null) {
            return info.getRegCount();
        }
        return -1;
    }

    public int getParamRegStart(String mthFullRawID) {
        SmaliMethodNode info = this.insnMap.get(mthFullRawID);
        if (info != null) {
            return info.getParamRegStart();
        }
        return -1;
    }

    public int getInsnPosByCodeOffset(String mthFullRawID, long codeOffset) {
        SmaliMethodNode info = this.insnMap.get(mthFullRawID);
        if (info != null) {
            return info.getInsnPos(codeOffset);
        }
        return -1;
    }

    @Nullable
    public Map.Entry<String, Integer> getMthFullIDAndCodeOffsetByLine(int line) {
        for (Map.Entry<String, SmaliMethodNode> entry : this.insnMap.entrySet()) {
            Integer codeOffset = entry.getValue().getLineMapping().get(line);
            if (codeOffset == null) continue;
            return new AbstractMap.SimpleEntry<String, Integer>(entry.getKey(), codeOffset);
        }
        return null;
    }

    public List<SmaliRegister> getRegisterList(String mthFullRawID) {
        SmaliMethodNode node = this.insnMap.get(mthFullRawID);
        if (node != null) {
            return node.getRegList();
        }
        return Collections.emptyList();
    }

    @Nullable
    public Object getResultRegOrField(String mthFullRawID, long codeOffset) {
        InsnNode insn;
        SmaliMethodNode info = this.insnMap.get(mthFullRawID);
        if (info != null && (insn = info.getInsnNode(codeOffset)) != null) {
            if (insn.getType() == InsnType.IPUT) {
                return ((IndexInsnNode)insn).getIndex();
            }
            if (insn.getType() == InsnType.INVOKE && insn instanceof InvokeNode && insn.getArgsCount() > 0) {
                return ((RegisterArg)insn.getArg(0)).getRegNum();
            }
            RegisterArg regArg = insn.getResult();
            if (regArg != null) {
                return regArg.getRegNum();
            }
        }
        return null;
    }

    private void writeClass(SmaliWriter smali, ClassNode cls) {
        List<IAnnotation> annos;
        IClassData clsData = cls.getClsData();
        if (clsData == null) {
            smali.startLine(String.format("###### Class %s is created by jadx", cls.getFullName()));
            return;
        }
        AttributeStorage clsAttributes = AttributeStorage.fromList(clsData.getAttributes());
        smali.startLine("Class: " + clsData.getType()).startLine("AccessFlags: " + AccessFlags.format(clsData.getAccessFlags(), AccessFlagsScope.CLASS)).startLine("SuperType: " + clsData.getSuperType()).startLine("Interfaces: " + String.valueOf(clsData.getInterfacesTypes())).startLine("SourceFile: " + String.valueOf(clsAttributes.get(JadxAttrType.SOURCE_FILE)));
        AnnotationsAttr annotationsAttr = clsAttributes.get(JadxAttrType.ANNOTATION_LIST);
        if (annotationsAttr != null && !(annos = annotationsAttr.getList()).isEmpty()) {
            smali.startLine(String.format("# %d annotations", annos.size()));
            this.writeAnnotations(smali, new ArrayList<IAnnotation>(annos));
            smali.startLine();
        }
        ArrayList<RawField> fields2 = new ArrayList<RawField>();
        int[] colWidths = new int[]{0, 0};
        int[] mthIndex = new int[]{0};
        LineInfo line = new LineInfo();
        clsData.visitFieldsAndMethods(f15 -> {
            RawField fld = RawField.make(f15);
            fields2.add(fld);
            if (fld.accessFlag.length() > colWidths[0]) {
                colWidths[0] = fld.accessFlag.length();
            }
            if (fld.name.length() > colWidths[1]) {
                colWidths[1] = fld.name.length();
            }
        }, m15 -> {
            if (!fields2.isEmpty()) {
                this.writeFields(smali, clsData, fields2, colWidths);
                fields2.clear();
            }
            try {
                int n15 = mthIndex[0];
                mthIndex[0] = n15 + 1;
                this.writeMethod(smali, cls.getMethods().get(n15), (IMethodData)m15, line);
            }
            catch (Throwable e15) {
                IMethodRef methodRef = m15.getMethodRef();
                String mthFullName = methodRef.getParentClassType() + "->" + methodRef.getName();
                smali.setIndent(0);
                smali.startLine("Failed to write method: " + mthFullName + "\n" + Utils.getStackTrace(e15));
                LOG.error("Failed to write smali code for method: {}", (Object)mthFullName, (Object)e15);
            }
            line.reset();
        });
        if (!fields2.isEmpty()) {
            this.writeFields(smali, clsData, fields2, colWidths);
        }
        for (ClassNode innerClass : cls.getInnerClasses()) {
            this.writeClass(smali, innerClass);
        }
    }

    private void writeFields(SmaliWriter smali, IClassData classData, List<RawField> fields2, int[] colWidths) {
        boolean staticIdx = false;
        smali.startLine().startLine("# fields");
        String whites = new String(new byte[Math.max(colWidths[0], colWidths[1])]).replace("\u0000", " ");
        for (RawField fld : fields2) {
            AnnotationsAttr annotationsAttr;
            EncodedValue constVal;
            smali.startLine();
            int pad = colWidths[0] - fld.accessFlag.length();
            if (pad > 0) {
                fld.accessFlag = fld.accessFlag + whites.substring(0, pad);
            }
            smali.add(".field ").add(fld.accessFlag);
            pad = colWidths[1] - fld.name.length();
            if (pad > 0) {
                fld.name = fld.name + whites.substring(0, pad);
            }
            smali.add(fld.name).add(" ");
            smali.add(": ").add(fld.type);
            if (fld.isStatic && (constVal = fld.attributes.get(JadxAttrType.CONSTANT_VALUE)) != null) {
                smali.add(" # init val = ");
                this.writeEncodedValue(smali, constVal, false);
            }
            if ((annotationsAttr = fld.attributes.get(JadxAttrType.ANNOTATION_LIST)) == null) continue;
            smali.incIndent();
            this.writeAnnotations(smali, annotationsAttr.getList());
            smali.decIndent();
        }
        smali.startLine();
    }

    private void writeMethod(SmaliWriter smali, MethodNode methodNode, IMethodData mth, LineInfo line) {
        if (insnDecoder == null) {
            insnDecoder = new SmaliInsnDecoder(methodNode);
        }
        smali.startLine().startLine(".method ");
        this.writeMethodDef(smali, mth, line);
        ICodeReader codeReader = mth.getCodeReader();
        if (codeReader != null) {
            int regsCount = codeReader.getRegistersCount();
            line.smaliMthNode.setParamRegStart(Smali.getParamStartRegNum(mth));
            line.smaliMthNode.setRegCount(regsCount);
            HashMap<Long, InsnNode> nodes = new HashMap<Long, InsnNode>(codeReader.getUnitsCount() / 2);
            line.smaliMthNode.setInsnNodes(nodes, codeReader.getUnitsCount());
            line.smaliMthNode.initRegInfoList(regsCount, codeReader.getUnitsCount());
            smali.incIndent();
            smali.startLine(".registers ").add(Integer.toString(regsCount));
            this.writeTries(codeReader, line);
            IDebugInfo debugInfo = codeReader.getDebugInfo();
            List<ILocalVar> localVars = debugInfo != null ? debugInfo.getLocalVars() : Collections.emptyList();
            this.formatMthParamInfo(mth, smali, line, regsCount, localVars);
            if (debugInfo != null) {
                this.formatDbgInfo(debugInfo, localVars, line);
            }
            smali.newLine();
            smali.startLine();
            codeReader.visitInstructions(insn -> {
                Opcode opcode = insn.getOpcode();
                if (opcode == Opcode.PACKED_SWITCH || opcode == Opcode.SPARSE_SWITCH) {
                    insn.decode();
                    line.addPayloadOffset(insn.getOffset(), insn.getTarget());
                }
            });
            codeReader.visitInstructions(insn -> {
                InsnNode node = this.decodeInsn((InsnData)insn, line);
                nodes.put(Long.valueOf(insn.getOffset()), node);
            });
            line.write(smali);
            this.insnMap.put(methodNode.getMethodInfo().getRawFullId(), line.smaliMthNode);
            smali.decIndent();
        }
        smali.startLine(".end method");
    }

    private void writeTries(ICodeReader codeReader, LineInfo line) {
        List<ITry> tries = codeReader.getTries();
        for (ITry aTry : tries) {
            int addr;
            int end = aTry.getEndOffset();
            String tryEndTip = String.format(FMT_TRY_END_TAG, end);
            String tryStartTip = String.format(FMT_TRY_TAG, aTry.getStartOffset());
            String tryStartTipExtra = " # :" + tryStartTip.substring(0, tryStartTip.length() - 1);
            line.addTip(aTry.getStartOffset(), tryStartTip, " # :" + tryEndTip.substring(0, tryEndTip.length() - 1));
            line.addTip(end, tryEndTip, tryStartTipExtra);
            ICatch iCatch = aTry.getCatch();
            int[] addresses = iCatch.getHandlers();
            for (int i15 = 0; i15 < addresses.length; ++i15) {
                addr = addresses[i15];
                String catchTip = String.format(FMT_CATCH_TAG, addr);
                line.addTip(addr, catchTip, " # " + iCatch.getTypes()[i15]);
                line.addTip(addr, catchTip, tryStartTipExtra);
                line.addTip(aTry.getStartOffset(), tryStartTip, " # :" + catchTip.substring(0, catchTip.length() - 1));
            }
            addr = iCatch.getCatchAllHandler();
            if (addr <= -1) continue;
            String catchAllTip = String.format(FMT_CATCH_ALL_TAG, addr);
            line.addTip(addr, catchAllTip, tryStartTipExtra);
            line.addTip(aTry.getStartOffset(), tryStartTip, " # :" + catchAllTip.substring(0, catchAllTip.length() - 1));
        }
    }

    private InsnNode decodeInsn(InsnData insn, LineInfo lineInfo) {
        insn.decode();
        InsnNode node = insnDecoder.decode(insn);
        this.formatInsn(insn, node, lineInfo);
        return node;
    }

    private void formatInsn(InsnData insn, InsnNode node, LineInfo line) {
        StringBuilder lw4 = line.getLineWriter();
        lw4.delete(0, lw4.length());
        this.fmtCols(insn, line);
        if (this.fmtPayloadInsn(insn, line)) {
            return;
        }
        lw4.append(this.formatInsnName(insn)).append(" ");
        this.fmtRegs(insn, node.getType(), line);
        if (!this.tryFormatTargetIns(insn, node.getType(), line)) {
            if (Smali.hasLiteral(insn)) {
                lw4.append(", ").append(Smali.literal(insn));
            } else if (node.getType() == InsnType.INVOKE) {
                lw4.append(", ").append(Smali.method(insn));
            } else if (insn.getIndexType() == InsnIndexType.FIELD_REF) {
                lw4.append(", ").append(Smali.field(insn));
            } else if (insn.getIndexType() == InsnIndexType.STRING_REF) {
                lw4.append(", ").append(Smali.str(insn));
            } else if (insn.getIndexType() == InsnIndexType.TYPE_REF) {
                lw4.append(", ").append(Smali.type(insn));
            } else if (insn.getOpcode() == Opcode.CONST_METHOD_HANDLE) {
                lw4.append(", ").append(Smali.methodHandle(insn));
            } else if (insn.getOpcode() == Opcode.CONST_METHOD_TYPE) {
                lw4.append(", ").append(Smali.proto(insn, insn.getIndex()));
            }
        }
        line.addInsnLine(insn.getOffset(), lw4.toString());
    }

    private String formatInsnName(InsnData insn) {
        if (this.isJavaBytecode) {
            return String.format("%-" + INSN_COL_WIDTH + "s | %-15s", insn.getOpcodeMnemonic(), insn.getOpcode().name().toLowerCase(Locale.ROOT).replace('_', '-'));
        }
        return String.format(FMT_INSN_COL, insn.getOpcodeMnemonic());
    }

    private boolean tryFormatTargetIns(InsnData insn, InsnType insnType, LineInfo line) {
        switch (insnType) {
            case IF: {
                int target = insn.getTarget();
                line.addTip(target, String.format(FMT_COND_TAG, target), "");
                line.getLineWriter().append(", ").append(String.format(FMT_COND, target));
                return true;
            }
            case GOTO: {
                int target = insn.getTarget();
                line.addTip(target, String.format(FMT_GOTO_TAG, target), "");
                line.getLineWriter().append(String.format(FMT_GOTO, target));
                return true;
            }
            case FILL_ARRAY: {
                int target = insn.getTarget();
                line.addTip(target, String.format(FMT_DATA_TAG, target), "");
                line.getLineWriter().append(", ").append(String.format(FMT_DATA, target));
                return true;
            }
            case SWITCH: {
                int target = insn.getTarget();
                if (insn.getOpcode() == Opcode.PACKED_SWITCH) {
                    line.addTip(target, String.format(FMT_P_SWITCH_TAG, target), "");
                    line.getLineWriter().append(", ").append(String.format(FMT_P_SWITCH, target));
                } else {
                    line.addTip(target, String.format(FMT_S_SWITCH_TAG, target), "");
                    line.getLineWriter().append(", ").append(String.format(FMT_S_SWITCH, target));
                }
                return true;
            }
        }
        return false;
    }

    private static boolean hasStaticFlag(int flag) {
        return (flag & 8) != 0;
    }

    private void writeMethodDef(SmaliWriter smali, IMethodData mth, LineInfo lineInfo) {
        smali.add(AccessFlags.format(mth.getAccessFlags(), AccessFlagsScope.METHOD));
        IMethodRef methodRef = mth.getMethodRef();
        methodRef.load();
        lineInfo.smaliMthNode.setDefPos(smali.getLength());
        smali.add(methodRef.getName()).add('(');
        methodRef.getArgTypes().forEach(smali::add);
        smali.add(')');
        smali.add(methodRef.getReturnType());
        AttributeStorage mthAttributes = AttributeStorage.fromList(mth.getAttributes());
        AnnotationsAttr annotationsAttr = mthAttributes.get(JadxAttrType.ANNOTATION_LIST);
        if (annotationsAttr != null && !annotationsAttr.isEmpty()) {
            smali.incIndent();
            this.writeAnnotations(smali, annotationsAttr.getList());
            smali.decIndent();
            smali.startLine();
        }
    }

    private void formatMthParamInfo(IMethodData mth, SmaliWriter smali, LineInfo line, int regsCount, List<ILocalVar> localVars) {
        List<String> types = mth.getMethodRef().getArgTypes();
        if (types.isEmpty()) {
            return;
        }
        int paramStart = 0;
        int regNum = line.smaliMthNode.getParamRegStart();
        if (!Smali.hasStaticFlag(mth.getAccessFlags())) {
            line.addRegName(regNum, "p0");
            line.smaliMthNode.setParamReg(regNum, "p0");
            ++regNum;
            ++paramStart;
        }
        if (localVars.isEmpty()) {
            return;
        }
        ILocalVar[] params = new ILocalVar[regsCount];
        for (ILocalVar var : localVars) {
            if (!var.isMarkedAsParameter()) continue;
            params[var.getRegNum()] = var;
        }
        smali.newLine();
        for (String paramType : types) {
            ILocalVar param = params[regNum];
            if (param != null) {
                String name = Utils.getOrElse(param.getName(), "");
                String type = Utils.getOrElse(param.getSignature(), paramType);
                String varName = "p" + paramStart;
                smali.startLine(String.format(".param %s, \"%s\" # %s", varName, name, type));
                line.addRegName(regNum, varName);
                line.smaliMthNode.setParamReg(regNum, varName);
            }
            int regSize = Smali.isWideType(paramType) ? 2 : 1;
            regNum += regSize;
            paramStart += regSize;
        }
    }

    private static int getParamStartRegNum(IMethodData mth) {
        int startNum;
        ICodeReader codeReader = mth.getCodeReader();
        if (codeReader != null && (startNum = codeReader.getRegistersCount()) > 0) {
            for (String argType : mth.getMethodRef().getArgTypes()) {
                if (Smali.isWideType(argType)) {
                    startNum -= 2;
                    continue;
                }
                --startNum;
            }
            if (!Smali.hasStaticFlag(mth.getAccessFlags())) {
                --startNum;
            }
            return startNum;
        }
        return -1;
    }

    private static boolean isWideType(String type) {
        return type.equals("D") || type.equals("J");
    }

    private void writeAnnotations(SmaliWriter smali, List<IAnnotation> annoList) {
        if (annoList.size() > 0) {
            for (int i15 = 0; i15 < annoList.size(); ++i15) {
                smali.startLine();
                this.writeAnnotation(smali, annoList.get(i15));
                if (i15 == annoList.size() - 1) continue;
                smali.startLine();
            }
        }
    }

    private void writeAnnotation(SmaliWriter smali, IAnnotation anno) {
        smali.add(".annotation").add(" ");
        AnnotationVisibility vby = anno.getVisibility();
        if (vby != null) {
            smali.add(vby.toString().toLowerCase()).add(" ");
        }
        smali.add(anno.getAnnotationClass());
        anno.getValues().forEach((k15, v15) -> {
            smali.incIndent();
            smali.startLine((String)k15).add(" = ");
            this.writeEncodedValue(smali, (EncodedValue)v15, true);
            smali.decIndent();
        });
        smali.startLine(".end annotation");
    }

    private void formatDbgInfo(IDebugInfo dbgInfo, List<ILocalVar> localVars, LineInfo line) {
        dbgInfo.getSourceLineMapping().forEach((codeOffset, srcLine) -> {
            if (codeOffset > -1) {
                line.addDebugLineTip((int)codeOffset, String.format(".line %d", srcLine), "");
            }
        });
        for (ILocalVar localVar : localVars) {
            if (localVar.isMarkedAsParameter()) continue;
            String type = localVar.getType();
            String sign = localVar.getSignature();
            String longTypeStr = sign == null || sign.trim().isEmpty() ? String.format(", \"%s\":%s", localVar.getName(), type) : String.format(", \"%s\":%s, \"%s\"", localVar.getName(), type, localVar.getSignature());
            line.addTip(localVar.getStartOffset(), ".local " + this.formatVarName(line.smaliMthNode, localVar), longTypeStr);
            line.addTip(localVar.getEndOffset(), ".end local " + this.formatVarName(line.smaliMthNode, localVar), String.format(" # \"%s\":%s", localVar.getName(), type));
        }
    }

    private String formatVarName(SmaliMethodNode smaliMthNode, ILocalVar localVar) {
        int paramRegStart = smaliMthNode.getParamRegStart();
        int regNum = localVar.getRegNum();
        if (regNum < paramRegStart) {
            return "v" + regNum;
        }
        return "p" + (regNum - paramRegStart);
    }

    private void writeEncodedValue(SmaliWriter smali, EncodedValue value, boolean wrapArray) {
        StringUtils stringUtils = smali.getClassNode().root().getStringUtils();
        switch (value.getType()) {
            case ENCODED_ARRAY: {
                smali.add("{");
                if (wrapArray) {
                    smali.incIndent();
                    smali.startLine();
                }
                List values2 = (List)value.getValue();
                for (int i15 = 0; i15 < values2.size(); ++i15) {
                    this.writeEncodedValue(smali, (EncodedValue)values2.get(i15), wrapArray);
                    if (i15 == values2.size() - 1) continue;
                    smali.add(",");
                    if (wrapArray) {
                        smali.startLine();
                        continue;
                    }
                    smali.add(" ");
                }
                if (!wrapArray) break;
                smali.decIndent();
                smali.startLine("}");
                break;
            }
            case ENCODED_NULL: {
                smali.add("null");
                break;
            }
            case ENCODED_ANNOTATION: {
                this.writeAnnotation(smali, (IAnnotation)value.getValue());
                break;
            }
            case ENCODED_BYTE: {
                smali.add(stringUtils.formatByte(((Byte)value.getValue()).byteValue(), false));
                break;
            }
            case ENCODED_SHORT: {
                smali.add(stringUtils.formatShort(((Short)value.getValue()).shortValue(), false));
                break;
            }
            case ENCODED_CHAR: {
                smali.add(stringUtils.unescapeChar(((Character)value.getValue()).charValue()));
                break;
            }
            case ENCODED_INT: {
                smali.add(stringUtils.formatInteger(((Integer)value.getValue()).intValue(), false));
                break;
            }
            case ENCODED_LONG: {
                smali.add(stringUtils.formatLong((Long)value.getValue(), false));
                break;
            }
            case ENCODED_FLOAT: {
                smali.add(StringUtils.formatFloat(((Float)value.getValue()).floatValue()));
                break;
            }
            case ENCODED_DOUBLE: {
                smali.add(StringUtils.formatDouble((Double)value.getValue()));
                break;
            }
            case ENCODED_STRING: {
                smali.add(stringUtils.unescapeString((String)value.getValue()));
                break;
            }
            case ENCODED_TYPE: {
                smali.add(String.valueOf(ArgType.parse((String)value.getValue())) + ".class");
                break;
            }
            default: {
                smali.add(String.valueOf(value.getValue()));
            }
        }
    }

    private void fmtRegs(InsnData insn, InsnType insnType, LineInfo line) {
        int resultReg;
        boolean appendBrace = insnType == InsnType.INVOKE || Smali.isRegList(insn);
        StringBuilder lw4 = line.getLineWriter();
        if (insnType == InsnType.INVOKE && (resultReg = insn.getResultReg()) != -1) {
            lw4.append(line.getRegName(resultReg)).append(" <= ");
        }
        if (appendBrace) {
            lw4.append("{");
        }
        if (Smali.isRangeRegIns(insn)) {
            lw4.append(line.getRegName(insn.getReg(0))).append(" .. ").append(line.getRegName(insn.getReg(insn.getRegsCount() - 1)));
        } else if (insn.getRegsCount() > 0) {
            for (int i15 = 0; i15 < insn.getRegsCount(); ++i15) {
                if (i15 > 0) {
                    lw4.append(", ");
                }
                lw4.append(line.getRegName(insn.getReg(i15)));
            }
        }
        if (appendBrace) {
            lw4.append("}");
        }
    }

    private int getInsnColStart() {
        int start = 0;
        start += 10;
        return start += 24;
    }

    private void fmtCols(InsnData insn, LineInfo line) {
        line.getLineWriter().append(String.format("%08x: ", insn.getFileOffset()));
        this.formatByteCode(line.getLineWriter(), insn.getByteCode());
        line.getLineWriter().append(" ");
        line.getLineWriter().append(String.format("%04x: ", insn.getOffset()));
    }

    private void formatByteCode(StringBuilder smali, byte[] bytes) {
        int maxLen = Math.min(bytes.length, 8);
        StringBuilder inHex = new StringBuilder();
        for (int i15 = 0; i15 < maxLen; ++i15) {
            inHex.append(String.format("%02x", bytes[i15]));
            if (i15 % 2 != 1) continue;
            inHex.append(' ');
        }
        smali.append(String.format(FMT_BYTECODE_COL, inHex));
        if (maxLen < bytes.length) {
            smali.append("...");
        } else {
            smali.append("   ");
        }
    }

    private boolean fmtPayloadInsn(InsnData insn, LineInfo line) {
        Opcode opcode = insn.getOpcode();
        if (opcode == Opcode.PACKED_SWITCH_PAYLOAD) {
            line.getLineWriter().append("packed-switch-payload");
            line.addInsnLine(insn.getOffset(), line.getLineWriter().toString());
            ISwitchPayload payload = (ISwitchPayload)insn.getPayload();
            if (payload != null) {
                this.fmtSwitchPayload(insn, FMT_P_SWITCH_CASE, FMT_P_SWITCH_CASE_TAG, line, payload);
            }
            return true;
        }
        if (opcode == Opcode.SPARSE_SWITCH_PAYLOAD) {
            line.getLineWriter().append("sparse-switch-payload");
            line.addInsnLine(insn.getOffset(), line.getLineWriter().toString());
            ISwitchPayload payload = (ISwitchPayload)insn.getPayload();
            if (payload != null) {
                this.fmtSwitchPayload(insn, FMT_S_SWITCH_CASE, FMT_S_SWITCH_CASE_TAG, line, payload);
            }
            return true;
        }
        if (opcode == Opcode.FILL_ARRAY_DATA_PAYLOAD) {
            line.getLineWriter().append("fill-array-data-payload");
            line.addInsnLine(insn.getOffset(), line.getLineWriter().toString());
            return true;
        }
        return false;
    }

    private void fmtSwitchPayload(InsnData insn, String fmtTarget, String fmtTag, LineInfo line, ISwitchPayload payload) {
        int lineStart = this.getInsnColStart();
        String basicIndent = new String(new byte[lineStart += 6]).replace("\u0000", " ");
        String indent = "    " + basicIndent;
        int[] keys2 = payload.getKeys();
        int[] targets = payload.getTargets();
        Integer switchOffset = line.payloadOffsetMap.get(insn.getOffset());
        if (switchOffset == null) {
            throw new JadxRuntimeException("Unknown switch insn for payload at " + insn.getOffset());
        }
        for (int i15 = 0; i15 < keys2.length; ++i15) {
            int target = switchOffset + targets[i15];
            line.addInsnLine(insn.getOffset(), String.format("%scase %d: -> " + fmtTarget, indent, keys2[i15], target));
            line.addTip(target, String.format(fmtTag, target), String.format(" # case %d", keys2[i15]));
        }
        line.addInsnLine(insn.getOffset(), basicIndent + ".end payload");
    }

    private static String literal(InsnData insn) {
        long it = insn.getLiteral();
        Object tip = "";
        if (it > Integer.MAX_VALUE) {
            if (Smali.isWideIns(insn)) {
                tip = " # double: " + Double.longBitsToDouble(it);
            } else if (Smali.getOpenCodeByte(insn) == 21) {
                tip = " # float: " + Float.intBitsToFloat((int)it);
            }
        } else if (it <= 0L) {
            return it + (String)tip;
        }
        return "0x" + Long.toHexString(it) + (String)tip;
    }

    private static String str(InsnData insn) {
        return String.format("\"%s\" # string@%04x", insn.getIndexAsString().replace("\n", "\\n").replace("\t", "\\t"), insn.getIndex());
    }

    private static String type(InsnData insn) {
        return String.format("%s # type@%04x", insn.getIndexAsType(), insn.getIndex());
    }

    private static String field(InsnData insn) {
        return String.format("%s # field@%04x", insn.getIndexAsField().toString(), insn.getIndex());
    }

    private static String method(InsnData insn) {
        Opcode op4 = insn.getOpcode();
        if (op4 == Opcode.INVOKE_CUSTOM || op4 == Opcode.INVOKE_CUSTOM_RANGE) {
            insn.getIndexAsCallSite().load();
            return String.format("%s # call_site@%04x", insn.getIndexAsCallSite().toString(), insn.getIndex());
        }
        IMethodRef mthRef = insn.getIndexAsMethod();
        mthRef.load();
        if (op4 == Opcode.INVOKE_POLYMORPHIC || op4 == Opcode.INVOKE_POLYMORPHIC_RANGE) {
            return String.format("%s, %s # method@%04x, proto@%04x", mthRef.toString(), insn.getIndexAsProto(insn.getTarget()).toString(), insn.getIndex(), insn.getTarget());
        }
        return String.format("%s # method@%04x", mthRef.toString(), insn.getIndex());
    }

    private static String proto(InsnData insn, int protoIndex) {
        return String.format("%s # proto@%04x", insn.getIndexAsProto(protoIndex).toString(), protoIndex);
    }

    private static String methodHandle(InsnData insn) {
        return String.format("%s # method_handle@%04x", insn.getIndexAsMethodHandle().toString(), insn.getIndex());
    }

    protected static boolean isRangeRegIns(InsnData insn) {
        switch (insn.getOpcode()) {
            case INVOKE_VIRTUAL_RANGE: 
            case INVOKE_SUPER_RANGE: 
            case INVOKE_DIRECT_RANGE: 
            case INVOKE_STATIC_RANGE: 
            case INVOKE_INTERFACE_RANGE: 
            case FILLED_NEW_ARRAY_RANGE: 
            case INVOKE_CUSTOM_RANGE: 
            case INVOKE_POLYMORPHIC_RANGE: {
                return true;
            }
        }
        return false;
    }

    private static int getOpenCodeByte(InsnData insn) {
        return insn.getRawOpcodeUnit() & 0xFF;
    }

    private static boolean isWideIns(InsnData insn) {
        return insn.getOpcode() == Opcode.CONST_WIDE;
    }

    private static boolean hasLiteral(InsnData insn) {
        int opcode = Smali.getOpenCodeByte(insn);
        return insn.getOpcode() == Opcode.CONST || insn.getOpcode() == Opcode.CONST_WIDE || opcode >= 208 && opcode <= 226;
    }

    private static boolean isRegList(InsnData insn) {
        return insn.getOpcode() == Opcode.FILLED_NEW_ARRAY || insn.getOpcode() == Opcode.FILLED_NEW_ARRAY_RANGE;
    }

    private class LineInfo {
        private SmaliMethodNode smaliMthNode = new SmaliMethodNode();
        private final StringBuilder lineWriter = new StringBuilder(50);
        private String lastDebugTip = "";
        private final Map<Integer, List<String>> insnOffsetMap = new LinkedHashMap<Integer, List<String>>();
        private final Map<Integer, String> regNameMap = new HashMap<Integer, String>();
        private Map<Integer, Map<String, Object>> tipMap = Collections.emptyMap();
        private Map<Integer, Integer> payloadOffsetMap = Collections.emptyMap();

        public StringBuilder getLineWriter() {
            return this.lineWriter;
        }

        public void reset() {
            this.lastDebugTip = "";
            this.payloadOffsetMap = Collections.emptyMap();
            this.tipMap = Collections.emptyMap();
            this.insnOffsetMap.clear();
            this.regNameMap.clear();
            this.smaliMthNode = new SmaliMethodNode();
        }

        public void addRegName(int regNum, String name) {
            this.regNameMap.put(regNum, name);
        }

        public String getRegName(int regNum) {
            Object name = this.regNameMap.get(regNum);
            if (name == null) {
                name = "v" + regNum;
            }
            return name;
        }

        public void addInsnLine(int codeOffset, String insnLine) {
            List insnList = this.insnOffsetMap.computeIfAbsent(codeOffset, k15 -> new ArrayList(1));
            insnList.add(insnLine);
        }

        public void addTip(int offset, String tip, String extra) {
            Map innerMap;
            Object obj;
            if (this.tipMap.isEmpty()) {
                this.tipMap = new LinkedHashMap<Integer, Map<String, Object>>();
            }
            if ((obj = (innerMap = this.tipMap.computeIfAbsent(offset, k15 -> new LinkedHashMap())).get(tip)) != null) {
                if (obj instanceof String) {
                    if (obj.equals("")) {
                        innerMap.put(tip, 2);
                    } else {
                        ArrayList<String> extras = new ArrayList<String>(2);
                        extras.add((String)obj);
                        extras.add(extra);
                        innerMap.put(tip, extras);
                    }
                } else if (obj instanceof Integer) {
                    innerMap.put(tip, (Integer)obj + 1);
                } else if (obj instanceof List && !extra.isEmpty()) {
                    List extras = (List)obj;
                    extras.add(extra);
                }
            } else {
                innerMap.put(tip, extra);
            }
        }

        public void addDebugLineTip(int offset, String tip, String extra) {
            if (tip.equals(this.lastDebugTip)) {
                return;
            }
            this.lastDebugTip = tip;
            if (this.tipMap.isEmpty()) {
                this.tipMap = new LinkedHashMap<Integer, Map<String, Object>>();
            }
            Map innerMap = this.tipMap.computeIfAbsent(offset, k15 -> new LinkedHashMap());
            innerMap.put(tip, extra);
        }

        public void addPayloadOffset(int curOffset, int payloadOffset) {
            if (this.payloadOffsetMap.isEmpty()) {
                this.payloadOffsetMap = new HashMap<Integer, Integer>();
            }
            this.payloadOffsetMap.put(payloadOffset, curOffset);
        }

        public void write(SmaliWriter smali) {
            int lineOffset = Smali.this.getInsnColStart();
            for (Map.Entry<Integer, List<String>> entry : this.insnOffsetMap.entrySet()) {
                this.writeTip(smali, entry.getKey(), lineOffset);
                this.smaliMthNode.setInsnInfo(entry.getKey(), lineOffset + smali.getLength());
                this.smaliMthNode.attachLine(smali.getLine(), entry.getKey());
                smali.attachSourceLine(entry.getKey());
                for (String s15 : entry.getValue()) {
                    smali.add(s15).startLine();
                }
            }
        }

        private void writeTip(SmaliWriter smali, int codeOffset, int lineOffset) {
            Map<String, Object> tip = this.tipMap.get(codeOffset);
            if (tip != null) {
                for (Map.Entry<String, Object> entry : tip.entrySet()) {
                    int start = Math.max(0, lineOffset - entry.getKey().length());
                    if (start > 0) {
                        smali.add(new String(new byte[start]).replace("\u0000", " "));
                    }
                    if (entry.getValue() instanceof Integer) {
                        smali.add(String.format("%s # %d refs", entry.getKey(), entry.getValue())).startLine();
                        continue;
                    }
                    if (entry.getValue() instanceof String) {
                        smali.add(String.format("%s%s", entry.getKey(), entry.getValue())).startLine();
                        continue;
                    }
                    if (entry.getValue() instanceof List) {
                        List extras = (List)entry.getValue();
                        smali.add(String.format("%s%s", entry.getKey(), extras.get(0))).startLine();
                        String pad = new String(new byte[lineOffset]).replace("\u0000", " ");
                        for (int i15 = 1; i15 < extras.size(); ++i15) {
                            smali.add(String.format("%s%s", pad, extras.get(i15))).startLine();
                        }
                        continue;
                    }
                    smali.add(String.format("%s%s", entry.getKey(), entry.getValue())).startLine();
                }
            }
        }
    }

    private static class RawField {
        boolean isStatic;
        String accessFlag;
        String name;
        String type;
        AttributeStorage attributes;

        private RawField() {
        }

        private static RawField make(IFieldData f15) {
            RawField field = new RawField();
            field.isStatic = Smali.hasStaticFlag(f15.getAccessFlags());
            field.accessFlag = AccessFlags.format(f15.getAccessFlags(), AccessFlagsScope.FIELD);
            field.name = f15.getName();
            field.type = f15.getType();
            field.attributes = AttributeStorage.fromList(f15.getAttributes());
            return field;
        }
    }

    private static class SmaliInsnDecoder
    extends InsnDecoder {
        @Override
        @NotNull
        protected InsnNode decode(InsnData insn) {
            try {
                return super.decode(insn);
            }
            catch (Exception e15) {
                switch (insn.getOpcode()) {
                    case INVOKE_CUSTOM_RANGE: 
                    case INVOKE_POLYMORPHIC_RANGE: 
                    case INVOKE_CUSTOM: 
                    case INVOKE_POLYMORPHIC: 
                    case CONST_METHOD_HANDLE: 
                    case CONST_METHOD_TYPE: {
                        return new InsnNode(InsnType.INVOKE, insn.getRegsCount());
                    }
                }
                throw new RuntimeException(e15);
            }
        }

        public SmaliInsnDecoder(MethodNode mthNode) {
            super(mthNode);
        }

        @Override
        public InsnNode[] process(ICodeReader codeReader) {
            return null;
        }
    }
}

