/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.search;

import jadx.api.JadxDecompiler;
import jadx.api.JavaClass;
import jadx.api.JavaPackage;
import jadx.core.dex.nodes.PackageNode;
import jadx.core.utils.exceptions.InvalidDataException;
import jadx.gui.search.ISearchMethod;
import jadx.gui.search.providers.ResourceFilter;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JResource;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.NLS;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class SearchSettings {
    private final String searchString;
    private boolean useRegex;
    private boolean ignoreCase;
    private String searchPkgStr;
    private String resFilterStr;
    private int resSizeLimit;
    private JClass activeCls;
    private JResource activeResource;
    private Pattern regexPattern;
    private ISearchMethod searchMethod;
    private JavaPackage searchPackage;
    private ResourceFilter resourceFilter;

    public SearchSettings(String searchString) {
        this.searchString = searchString;
    }

    @Nullable
    public String prepare(MainWindow mainWindow) {
        if (this.useRegex) {
            try {
                int flags = this.ignoreCase ? 2 : 0;
                this.regexPattern = Pattern.compile(this.searchString, flags);
            }
            catch (Exception e15) {
                return "Invalid Regex: " + e15.getMessage();
            }
        }
        if (!this.searchPkgStr.isBlank()) {
            JadxDecompiler decompiler = mainWindow.getWrapper().getDecompiler();
            PackageNode pkg = decompiler.getRoot().resolvePackage(this.searchPkgStr);
            if (pkg == null) {
                return NLS.str("search_dialog.package_not_found");
            }
            this.searchPackage = pkg.getJavaNode();
        }
        this.searchMethod = ISearchMethod.build(this);
        try {
            this.resourceFilter = ResourceFilter.parse(this.resFilterStr);
        }
        catch (InvalidDataException e16) {
            return "Invalid resource file filter: " + e16.getMessage();
        }
        return null;
    }

    public boolean isMatch(String searchArea) {
        return this.searchMethod.find(searchArea, this.searchString, 0) != -1;
    }

    public boolean isUseRegex() {
        return this.useRegex;
    }

    public void setUseRegex(boolean useRegex) {
        this.useRegex = useRegex;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public JavaPackage getSearchPackage() {
        return this.searchPackage;
    }

    public boolean isInSearchPkg(JavaClass cls) {
        return cls.getJavaPackage().isDescendantOf(this.searchPackage);
    }

    public void setSearchPkgStr(String searchPkgStr) {
        this.searchPkgStr = searchPkgStr;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public Pattern getPattern() {
        return this.regexPattern;
    }

    public JClass getActiveCls() {
        return this.activeCls;
    }

    public void setActiveCls(JClass activeCls) {
        this.activeCls = activeCls;
    }

    public JResource getActiveResource() {
        return this.activeResource;
    }

    public void setActiveResource(JResource activeResource) {
        this.activeResource = activeResource;
    }

    public ISearchMethod getSearchMethod() {
        return this.searchMethod;
    }

    public void setResFilterStr(String resFilterStr) {
        this.resFilterStr = resFilterStr;
    }

    public ResourceFilter getResourceFilter() {
        return this.resourceFilter;
    }

    public int getResSizeLimit() {
        return this.resSizeLimit;
    }

    public void setResSizeLimit(int resSizeLimit) {
        this.resSizeLimit = resSizeLimit;
    }
}

