/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.tools;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import jadx.core.utils.GsonUtils;
import jadx.core.utils.files.FileUtils;
import jadx.plugins.tools.data.JadxPluginListCache;
import jadx.plugins.tools.data.JadxPluginListEntry;
import jadx.plugins.tools.resolvers.github.GithubTools;
import jadx.plugins.tools.resolvers.github.LocationInfo;
import jadx.plugins.tools.resolvers.github.data.Asset;
import jadx.plugins.tools.resolvers.github.data.Release;
import jadx.plugins.tools.utils.PluginFiles;
import jadx.plugins.tools.utils.PluginUtils;
import jadx.zip.ZipReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxPluginsList {
    private static final Logger LOG = LoggerFactory.getLogger(JadxPluginsList.class);
    private static final JadxPluginsList INSTANCE = new JadxPluginsList();
    private static final Type LIST_TYPE = new TypeToken<List<JadxPluginListEntry>>(){}.getType();
    private static final Type CACHE_TYPE = new TypeToken<JadxPluginListCache>(){}.getType();
    @Nullable
    private JadxPluginListCache loadedList;

    public static JadxPluginsList getInstance() {
        return INSTANCE;
    }

    private JadxPluginsList() {
    }

    public synchronized void get(Consumer<List<JadxPluginListEntry>> consumer) {
        if (this.loadedList != null) {
            consumer.accept(this.loadedList.getList());
            return;
        }
        JadxPluginListCache listCache = this.loadCache();
        if (listCache != null) {
            consumer.accept(listCache.getList());
            this.loadedList = listCache;
        }
        Release release = this.fetchLatestRelease();
        if (listCache == null || !listCache.getVersion().equals(release.getName())) {
            JadxPluginListCache updatedList = this.fetchBundle(release);
            this.saveCache(updatedList);
            consumer.accept(updatedList.getList());
            this.loadedList = updatedList;
        }
    }

    public List<JadxPluginListEntry> get() {
        AtomicReference holder = new AtomicReference();
        this.get(holder::set);
        return (List)holder.get();
    }

    @Nullable
    private JadxPluginListCache loadCache() {
        if (!Files.isRegularFile(PluginFiles.PLUGINS_LIST_CACHE, new LinkOption[0])) {
            return null;
        }
        try {
            String jsonStr = FileUtils.readFile(PluginFiles.PLUGINS_LIST_CACHE);
            return (JadxPluginListCache)GsonUtils.buildGson().fromJson(jsonStr, CACHE_TYPE);
        }
        catch (Exception e15) {
            return null;
        }
    }

    private void saveCache(JadxPluginListCache listCache) {
        try {
            String jsonStr = GsonUtils.buildGson().toJson((Object)listCache, CACHE_TYPE);
            FileUtils.writeFile(PluginFiles.PLUGINS_LIST_CACHE, jsonStr);
        }
        catch (Exception e15) {
            throw new RuntimeException("Error saving file: " + String.valueOf(PluginFiles.PLUGINS_LIST_CACHE), e15);
        }
    }

    private Release fetchLatestRelease() {
        LOG.debug("Fetching latest plugins-list release info");
        LocationInfo pluginsList = new LocationInfo("jadx-decompiler", "jadx-plugins-list", "list");
        Release release = GithubTools.fetchRelease(pluginsList);
        List<Asset> assets = release.getAssets();
        if (assets.isEmpty()) {
            throw new RuntimeException("Release don't have assets");
        }
        return release;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JadxPluginListCache fetchBundle(Release release) {
        JadxPluginListCache jadxPluginListCache;
        LOG.debug("Fetching plugins-list bundle: {}", (Object)release.getName());
        Asset listAsset = release.getAssets().get(0);
        Path tmpListFile = Files.createTempFile("plugins-list", ".zip", new FileAttribute[0]);
        try {
            PluginUtils.downloadFile(listAsset.getDownloadUrl(), tmpListFile);
            JadxPluginListCache listCache = new JadxPluginListCache();
            listCache.setVersion(release.getName());
            listCache.setList(JadxPluginsList.loadListBundle(tmpListFile));
            jadxPluginListCache = listCache;
        }
        catch (Throwable throwable) {
            try {
                Files.deleteIfExists(tmpListFile);
                throw throwable;
            }
            catch (Exception e15) {
                throw new RuntimeException("Failed to load plugin-list bundle for release:" + release.getName(), e15);
            }
        }
        Files.deleteIfExists(tmpListFile);
        return jadxPluginListCache;
    }

    private static List<JadxPluginListEntry> loadListBundle(Path tmpListFile) {
        Gson gson = GsonUtils.buildGson();
        ArrayList<JadxPluginListEntry> entries = new ArrayList<JadxPluginListEntry>();
        new ZipReader().visitEntries(tmpListFile.toFile(), entry -> {
            if (entry.getName().endsWith(".json")) {
                try (InputStreamReader reader = new InputStreamReader(entry.getInputStream());){
                    entries.addAll((Collection)gson.fromJson((Reader)reader, LIST_TYPE));
                }
                catch (Exception e15) {
                    throw new RuntimeException("Failed to read plugins list entry: " + entry.getName());
                }
            }
            return null;
        });
        return entries;
    }
}

