/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.format.enigma;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.format.enigma.EnigmaWriterBase;

public final class EnigmaDirWriter
extends EnigmaWriterBase {
    private final Path dir;
    private final boolean deleteExistingFiles;

    public EnigmaDirWriter(Path dir, boolean deleteExistingFiles) throws IOException {
        super(null);
        this.dir = dir.toAbsolutePath().normalize();
        this.deleteExistingFiles = deleteExistingFiles;
    }

    @Override
    public boolean visitHeader() throws IOException {
        if (this.deleteExistingFiles && Files.exists(this.dir, new LinkOption[0])) {
            Files.walkFileTree(this.dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
                    if (file2.getFileName().toString().endsWith("." + MappingFormat.ENIGMA_FILE.fileExt)) {
                        Files.delete(file2);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path file2, IOException exc) throws IOException {
                    try {
                        if (!EnigmaDirWriter.this.dir.equals(file2)) {
                            Files.delete(file2);
                        }
                    }
                    catch (DirectoryNotEmptyException directoryNotEmptyException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return super.visitHeader();
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
            this.currentClass = null;
        }
    }

    @Override
    void visitClassContent() throws IOException {
        String name;
        String string = name = this.dstName != null ? this.dstName : this.srcClassName;
        if (this.currentClass == null || !name.startsWith(this.currentClass) || name.length() > this.currentClass.length() && name.charAt(this.currentClass.length()) != '$') {
            Path file2;
            int pos = EnigmaDirWriter.getNextOuterEnd(name, 0);
            if (pos >= 0) {
                name = name.substring(0, pos);
            }
            if (!(file2 = this.dir.resolve(name + "." + MappingFormat.ENIGMA_FILE.fileExt).normalize()).startsWith(this.dir)) {
                throw new RuntimeException("invalid name: " + name);
            }
            if (this.writer != null) {
                this.writer.close();
            }
            this.currentClass = name;
            if (Files.exists(file2, new LinkOption[0])) {
                ArrayList<String> writtenClassParts = new ArrayList<String>();
                try (BufferedReader reader = Files.newBufferedReader(file2);){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        int offset;
                        for (offset = 0; offset < line.length() && line.charAt(offset) == '\t'; ++offset) {
                        }
                        if (!line.startsWith("CLASS ", offset)) continue;
                        int start = offset + 6;
                        int end = line.indexOf(32, start);
                        if (end < 0) {
                            end = line.length();
                        }
                        String part = line.substring(start, end);
                        while (writtenClassParts.size() > offset) {
                            writtenClassParts.remove(writtenClassParts.size() - 1);
                        }
                        writtenClassParts.add(part);
                    }
                }
                this.lastWrittenClass = String.join((CharSequence)"$", writtenClassParts);
            } else {
                this.lastWrittenClass = "";
                Files.createDirectories(file2.getParent(), new FileAttribute[0]);
            }
            this.writer = Files.newBufferedWriter(file2, StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        }
        this.writeMismatchedOrMissingClasses();
    }
}

