/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.DebugEventListener;

public class DebugTokenStream
implements TokenStream {
    protected DebugEventListener dbg;
    public TokenStream input;
    protected boolean initialStreamState = true;
    protected int lastMarker;

    public DebugTokenStream(TokenStream input, DebugEventListener dbg) {
        this.input = input;
        this.setDebugListener(dbg);
        input.LT(1);
    }

    public void setDebugListener(DebugEventListener dbg) {
        this.dbg = dbg;
    }

    public void consume() {
        if (this.initialStreamState) {
            this.consumeInitialHiddenTokens();
        }
        int a15 = this.input.index();
        Token t15 = this.input.LT(1);
        this.input.consume();
        int b15 = this.input.index();
        this.dbg.consumeToken(t15);
        if (b15 > a15 + 1) {
            for (int i15 = a15 + 1; i15 < b15; ++i15) {
                this.dbg.consumeHiddenToken(this.input.get(i15));
            }
        }
    }

    protected void consumeInitialHiddenTokens() {
        int firstOnChannelTokenIndex = this.input.index();
        for (int i15 = 0; i15 < firstOnChannelTokenIndex; ++i15) {
            this.dbg.consumeHiddenToken(this.input.get(i15));
        }
        this.initialStreamState = false;
    }

    public Token LT(int i15) {
        if (this.initialStreamState) {
            this.consumeInitialHiddenTokens();
        }
        this.dbg.LT(i15, this.input.LT(i15));
        return this.input.LT(i15);
    }

    public int LA(int i15) {
        if (this.initialStreamState) {
            this.consumeInitialHiddenTokens();
        }
        this.dbg.LT(i15, this.input.LT(i15));
        return this.input.LA(i15);
    }

    public Token get(int i15) {
        return this.input.get(i15);
    }

    public int mark() {
        this.lastMarker = this.input.mark();
        this.dbg.mark(this.lastMarker);
        return this.lastMarker;
    }

    public int index() {
        return this.input.index();
    }

    public int range() {
        return this.input.range();
    }

    public void rewind(int marker) {
        this.dbg.rewind(marker);
        this.input.rewind(marker);
    }

    public void rewind() {
        this.dbg.rewind();
        this.input.rewind(this.lastMarker);
    }

    public void release(int marker) {
    }

    public void seek(int index) {
        this.input.seek(index);
    }

    public int size() {
        return this.input.size();
    }

    public TokenSource getTokenSource() {
        return this.input.getTokenSource();
    }

    public String getSourceName() {
        return this.getTokenSource().getSourceName();
    }

    public String toString() {
        return this.input.toString();
    }

    public String toString(int start, int stop) {
        return this.input.toString(start, stop);
    }

    public String toString(Token start, Token stop) {
        return this.input.toString(start, stop);
    }
}

