/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.tree;

import java.util.HashMap;
import java.util.Map;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonErrorNode;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;

public abstract class BaseTreeAdaptor
implements TreeAdaptor {
    protected Map<Object, Integer> treeToUniqueIDMap;
    protected int uniqueNodeID = 1;

    public Object nil() {
        return this.create(null);
    }

    public Object errorNode(TokenStream input, Token start, Token stop, RecognitionException e15) {
        CommonErrorNode t15 = new CommonErrorNode(input, start, stop, e15);
        return t15;
    }

    public boolean isNil(Object tree) {
        return ((Tree)tree).isNil();
    }

    public Object dupTree(Object tree) {
        return this.dupTree(tree, null);
    }

    public Object dupTree(Object t15, Object parent) {
        if (t15 == null) {
            return null;
        }
        Object newTree = this.dupNode(t15);
        this.setChildIndex(newTree, this.getChildIndex(t15));
        this.setParent(newTree, parent);
        int n15 = this.getChildCount(t15);
        for (int i15 = 0; i15 < n15; ++i15) {
            Object child = this.getChild(t15, i15);
            Object newSubTree = this.dupTree(child, t15);
            this.addChild(newTree, newSubTree);
        }
        return newTree;
    }

    public void addChild(Object t15, Object child) {
        if (t15 != null && child != null) {
            ((Tree)t15).addChild((Tree)child);
        }
    }

    public Object becomeRoot(Object newRoot, Object oldRoot) {
        Tree newRootTree = (Tree)newRoot;
        Tree oldRootTree = (Tree)oldRoot;
        if (oldRoot == null) {
            return newRoot;
        }
        if (newRootTree.isNil()) {
            int nc5 = newRootTree.getChildCount();
            if (nc5 == 1) {
                newRootTree = newRootTree.getChild(0);
            } else if (nc5 > 1) {
                throw new RuntimeException("more than one node as root (TODO: make exception hierarchy)");
            }
        }
        newRootTree.addChild(oldRootTree);
        return newRootTree;
    }

    public Object rulePostProcessing(Object root) {
        Tree r15 = (Tree)root;
        if (r15 != null && r15.isNil()) {
            if (r15.getChildCount() == 0) {
                r15 = null;
            } else if (r15.getChildCount() == 1) {
                r15 = r15.getChild(0);
                r15.setParent(null);
                r15.setChildIndex(-1);
            }
        }
        return r15;
    }

    public Object becomeRoot(Token newRoot, Object oldRoot) {
        return this.becomeRoot(this.create(newRoot), oldRoot);
    }

    public Object create(int tokenType, Token fromToken) {
        fromToken = this.createToken(fromToken);
        fromToken.setType(tokenType);
        Tree t15 = (Tree)this.create(fromToken);
        return t15;
    }

    public Object create(int tokenType, Token fromToken, String text) {
        if (fromToken == null) {
            return this.create(tokenType, text);
        }
        fromToken = this.createToken(fromToken);
        fromToken.setType(tokenType);
        fromToken.setText(text);
        Tree t15 = (Tree)this.create(fromToken);
        return t15;
    }

    public Object create(int tokenType, String text) {
        Token fromToken = this.createToken(tokenType, text);
        Tree t15 = (Tree)this.create(fromToken);
        return t15;
    }

    public int getType(Object t15) {
        return ((Tree)t15).getType();
    }

    public void setType(Object t15, int type) {
        throw new NoSuchMethodError("don't know enough about Tree node");
    }

    public String getText(Object t15) {
        return ((Tree)t15).getText();
    }

    public void setText(Object t15, String text) {
        throw new NoSuchMethodError("don't know enough about Tree node");
    }

    public Object getChild(Object t15, int i15) {
        return ((Tree)t15).getChild(i15);
    }

    public void setChild(Object t15, int i15, Object child) {
        ((Tree)t15).setChild(i15, (Tree)child);
    }

    public Object deleteChild(Object t15, int i15) {
        return ((Tree)t15).deleteChild(i15);
    }

    public int getChildCount(Object t15) {
        return ((Tree)t15).getChildCount();
    }

    public int getUniqueID(Object node) {
        Integer prevID;
        if (this.treeToUniqueIDMap == null) {
            this.treeToUniqueIDMap = new HashMap<Object, Integer>();
        }
        if ((prevID = this.treeToUniqueIDMap.get(node)) != null) {
            return prevID;
        }
        int ID2 = this.uniqueNodeID++;
        this.treeToUniqueIDMap.put(node, ID2);
        return ID2;
    }

    public abstract Token createToken(int var1, String var2);

    public abstract Token createToken(Token var1);
}

