/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.lookup.AbstractPathFencedLookup;
import org.apache.commons.text.lookup.IllegalArgumentExceptions;
import org.w3c.dom.Document;

final class XmlStringLookup
extends AbstractPathFencedLookup {
    private static final int KEY_PARTS_LEN = 2;
    static final Map<String, Boolean> DEFAULT_XPATH_FEATURES = new HashMap<String, Boolean>(1);
    static final Map<String, Boolean> DEFAULT_XML_FEATURES;
    static final XmlStringLookup INSTANCE;
    private final Map<String, Boolean> xPathFactoryFeatures;
    private final Map<String, Boolean> xmlFactoryFeatures;

    XmlStringLookup(Map<String, Boolean> xmlFactoryFeatures, Map<String, Boolean> xPathFactoryFeatures, Path ... fences) {
        super(fences);
        this.xmlFactoryFeatures = Objects.requireNonNull(xmlFactoryFeatures, "xmlFactoryFeatures");
        this.xPathFactoryFeatures = Objects.requireNonNull(xPathFactoryFeatures, "xPathFfactoryFeatures");
    }

    @Override
    public String lookup(String key) {
        String string;
        block12: {
            if (key == null) {
                return null;
            }
            String[] keys2 = key.split(SPLIT_STR);
            int keyLen = keys2.length;
            if (keyLen != 2) {
                throw IllegalArgumentExceptions.format("Bad XML key format '%s'; the expected format is 'DocumentPath:XPath'.", key);
            }
            String documentPath = keys2[0];
            String xpath = StringUtils.substringAfterLast(key, 58);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            for (Map.Entry<String, Boolean> p15 : this.xmlFactoryFeatures.entrySet()) {
                dbFactory.setFeature(p15.getKey(), p15.getValue());
            }
            InputStream inputStream = Files.newInputStream(this.getPath(documentPath), new OpenOption[0]);
            try {
                Document doc = dbFactory.newDocumentBuilder().parse(inputStream);
                XPathFactory xpFactory = XPathFactory.newInstance();
                for (Map.Entry<String, Boolean> p16 : this.xPathFactoryFeatures.entrySet()) {
                    xpFactory.setFeature(p16.getKey(), p16.getValue());
                }
                string = xpFactory.newXPath().evaluate(xpath, doc);
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e15) {
                    throw new IllegalArgumentException(e15);
                }
            }
            inputStream.close();
        }
        return string;
    }

    static {
        DEFAULT_XPATH_FEATURES.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        DEFAULT_XML_FEATURES = new HashMap<String, Boolean>(1);
        DEFAULT_XML_FEATURES.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        INSTANCE = new XmlStringLookup(DEFAULT_XML_FEATURES, DEFAULT_XPATH_FEATURES, (Path[])null);
    }
}

