/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterChoicesProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionContext;
import org.fife.ui.autocomplete.SortByRelevanceComparator;
import org.fife.ui.autocomplete.Util;
import org.fife.ui.rsyntaxtextarea.PopupWindowDecorator;

public class ParameterizedCompletionChoicesWindow
extends JWindow {
    private AutoCompletion ac;
    private JList<Completion> list;
    private DefaultListModel<Completion> model;
    private List<List<Completion>> choicesListList;
    private JScrollPane sp;
    private static final Comparator<Completion> SORT_BY_RELEVANCE_COMPARATOR = new SortByRelevanceComparator();

    public ParameterizedCompletionChoicesWindow(Window parent, AutoCompletion ac5, final ParameterizedCompletionContext context) {
        super(parent);
        this.ac = ac5;
        ComponentOrientation o15 = ac5.getTextComponentOrientation();
        this.model = new DefaultListModel();
        this.list = new JList<Completion>(this.model);
        if (ac5.getParamChoicesRenderer() != null) {
            this.list.setCellRenderer(ac5.getParamChoicesRenderer());
        }
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e15) {
                if (e15.getClickCount() == 2) {
                    context.insertSelectedChoice();
                }
            }
        });
        this.sp = new JScrollPane(this.list);
        this.setContentPane(this.sp);
        this.applyComponentOrientation(o15);
        this.setFocusableWindowState(false);
        PopupWindowDecorator decorator = PopupWindowDecorator.get();
        if (decorator != null) {
            decorator.decorate(this);
        }
    }

    public String getSelectedChoice() {
        Completion c15 = this.list.getSelectedValue();
        return c15 == null ? null : c15.toString();
    }

    public void incSelection(int amount) {
        int selection = this.list.getSelectedIndex();
        selection = (selection += amount) < 0 ? this.model.getSize() - 1 : (selection %= this.model.getSize());
        this.list.setSelectedIndex(selection);
        this.list.ensureIndexIsVisible(selection);
    }

    public void initialize(ParameterizedCompletion pc5) {
        CompletionProvider provider = pc5.getProvider();
        ParameterChoicesProvider pcp = provider.getParameterChoicesProvider();
        if (pcp == null) {
            this.choicesListList = null;
            return;
        }
        int paramCount = pc5.getParamCount();
        this.choicesListList = new ArrayList<List<Completion>>(paramCount);
        JTextComponent tc5 = this.ac.getTextComponent();
        for (int i15 = 0; i15 < paramCount; ++i15) {
            ParameterizedCompletion.Parameter param = pc5.getParam(i15);
            List<Completion> choices = pcp.getParameterChoices(tc5, param);
            this.choicesListList.add(choices);
        }
    }

    public void setLocationRelativeTo(Rectangle r15) {
        Rectangle screenBounds = Util.getScreenBoundsForPoint(r15.x, r15.y);
        int y15 = r15.y + r15.height + 5;
        int x15 = r15.x;
        if (x15 < screenBounds.x) {
            x15 = screenBounds.x;
        } else if (x15 + this.getWidth() > screenBounds.x + screenBounds.width) {
            x15 = screenBounds.x + screenBounds.width - this.getWidth();
        }
        this.setLocation(x15, y15);
    }

    public void setParameter(int param, String prefix) {
        this.model.clear();
        ArrayList<Completion> temp = new ArrayList<Completion>();
        if (this.choicesListList != null && param >= 0 && param < this.choicesListList.size()) {
            List<Completion> choices = this.choicesListList.get(param);
            if (choices != null) {
                for (Completion completion : choices) {
                    String string = completion.getReplacementText();
                    if (prefix != null && !Util.startsWithIgnoreCase(string, prefix)) continue;
                    temp.add(completion);
                }
            }
            Comparator<Completion> c16 = null;
            c16 = SORT_BY_RELEVANCE_COMPARATOR;
            temp.sort(c16);
            for (Completion completion : temp) {
                this.model.addElement(completion);
            }
            int n15 = Math.min(this.model.size(), 10);
            this.list.setVisibleRowCount(n15);
            if (n15 == 0 && this.isVisible()) {
                this.setVisible(false);
            } else if (n15 > 0) {
                Dimension dimension = this.getPreferredSize();
                if (dimension.width < 150) {
                    this.setSize(150, dimension.height);
                } else {
                    this.pack();
                }
                if (this.sp.getVerticalScrollBar() != null && this.sp.getVerticalScrollBar().isVisible()) {
                    Dimension dimension2 = this.getSize();
                    int w15 = dimension2.width + this.sp.getVerticalScrollBar().getWidth() + 5;
                    this.setSize(w15, dimension2.height);
                }
                this.list.setSelectedIndex(0);
                this.list.ensureIndexIsVisible(0);
                if (!this.isVisible()) {
                    this.setVisible(true);
                }
            }
        } else {
            this.setVisible(false);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible != this.isVisible()) {
            if (visible && this.model.size() == 0) {
                return;
            }
            super.setVisible(visible);
        }
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this);
    }
}

