/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.fife.ui.rsyntaxtextarea.TokenMaker;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;

public abstract class AbstractTokenMakerFactory
extends TokenMakerFactory {
    private Map<String, Object> tokenMakerMap = new HashMap<String, Object>();

    protected AbstractTokenMakerFactory() {
        this.initTokenMakerMap();
    }

    @Override
    protected TokenMaker getTokenMakerImpl(String key) {
        TokenMakerCreator tmc = (TokenMakerCreator)this.tokenMakerMap.get(key);
        if (tmc != null) {
            try {
                return tmc.create();
            }
            catch (RuntimeException re5) {
                throw re5;
            }
            catch (Exception e15) {
                e15.printStackTrace();
            }
        }
        return null;
    }

    protected abstract void initTokenMakerMap();

    @Override
    public Set<String> keySet() {
        return this.tokenMakerMap.keySet();
    }

    public void putMapping(String key, String className) {
        this.putMapping(key, className, null);
    }

    public void putMapping(String key, String className, ClassLoader cl4) {
        this.tokenMakerMap.put(key, new TokenMakerCreator(className, cl4));
    }

    private static class TokenMakerCreator {
        private String className;
        private ClassLoader cl;

        TokenMakerCreator(String className, ClassLoader cl4) {
            this.className = className;
            this.cl = cl4 != null ? cl4 : this.getClass().getClassLoader();
        }

        public TokenMaker create() throws Exception {
            return (TokenMaker)Class.forName(this.className, true, this.cl).newInstance();
        }
    }
}

