/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.SquiggleUnderlineHighlightPainter;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ToolTipInfo;
import org.fife.ui.rtextarea.RDocument;
import org.fife.ui.rtextarea.RTextAreaHighlighter;

class ParserManager
implements DocumentListener,
ActionListener,
HyperlinkListener,
PropertyChangeListener {
    private RSyntaxTextArea textArea;
    private List<Parser> parsers;
    private Timer timer;
    private boolean running;
    private Parser parserForTip;
    private Position firstOffsetModded;
    private Position lastOffsetModded;
    private List<NoticeHighlightPair> noticeHighlightPairs;
    private SquiggleUnderlineHighlightPainter parserErrorHighlightPainter = new SquiggleUnderlineHighlightPainter(Color.RED);
    private static final int DEFAULT_DELAY_MS = 1250;

    ParserManager(RSyntaxTextArea textArea) {
        this(1250, textArea);
    }

    ParserManager(int delay, RSyntaxTextArea textArea) {
        this.textArea = textArea;
        textArea.getDocument().addDocumentListener(this);
        textArea.addPropertyChangeListener("document", this);
        this.parsers = new ArrayList<Parser>(1);
        this.timer = new Timer(delay, this);
        this.timer.setRepeats(false);
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e15) {
        int parserCount = this.getParserCount();
        if (parserCount == 0) {
            return;
        }
        RSyntaxDocument doc = (RSyntaxDocument)this.textArea.getDocument();
        this.lastOffsetModded = null;
        this.firstOffsetModded = null;
        String style = this.textArea.getSyntaxEditingStyle();
        doc.readLock();
        try {
            for (int i15 = 0; i15 < parserCount; ++i15) {
                Parser parser = this.getParser(i15);
                if (parser.isEnabled()) {
                    ParseResult res = parser.parse(doc, style);
                    this.addParserNoticeHighlights(res);
                    continue;
                }
                this.clearParserNoticeHighlights(parser);
            }
            this.textArea.fireParserNoticesChange();
        }
        finally {
            doc.readUnlock();
        }
    }

    public void addParser(Parser parser) {
        if (parser != null && !this.parsers.contains(parser)) {
            if (this.running) {
                this.timer.stop();
            }
            this.parsers.add(parser);
            if (this.parsers.size() == 1) {
                ToolTipManager.sharedInstance().registerComponent(this.textArea);
            }
            if (this.running) {
                this.timer.restart();
            }
        }
    }

    private void addParserNoticeHighlights(ParseResult res) {
        if (res == null) {
            return;
        }
        if (this.noticeHighlightPairs == null) {
            this.noticeHighlightPairs = new ArrayList<NoticeHighlightPair>();
        }
        this.removeParserNotices(res);
        List<ParserNotice> notices = res.getNotices();
        if (!notices.isEmpty()) {
            RSyntaxTextAreaHighlighter h15 = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
            for (ParserNotice notice : notices) {
                try {
                    RTextAreaHighlighter.HighlightInfo highlight = null;
                    if (notice.getShowInEditor()) {
                        highlight = h15.addParserHighlight(notice, this.parserErrorHighlightPainter);
                    }
                    this.noticeHighlightPairs.add(new NoticeHighlightPair(notice, highlight));
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e15) {
    }

    private void clearParserNoticeHighlights() {
        RSyntaxTextAreaHighlighter h15 = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
        if (h15 != null) {
            h15.clearParserHighlights();
        }
        if (this.noticeHighlightPairs != null) {
            this.noticeHighlightPairs.clear();
        }
    }

    private void clearParserNoticeHighlights(Parser parser) {
        RSyntaxTextAreaHighlighter h15 = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
        if (h15 != null) {
            h15.clearParserHighlights(parser);
        }
        if (this.noticeHighlightPairs != null) {
            this.noticeHighlightPairs.removeIf(pair -> ((NoticeHighlightPair)pair).notice.getParser() == parser);
        }
    }

    public void clearParsers() {
        this.timer.stop();
        this.clearParserNoticeHighlights();
        this.parsers.clear();
        this.textArea.fireParserNoticesChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceReparsing(int parser) {
        Parser p15 = this.getParser(parser);
        RSyntaxDocument doc = (RSyntaxDocument)this.textArea.getDocument();
        String style = this.textArea.getSyntaxEditingStyle();
        doc.readLock();
        try {
            if (p15.isEnabled()) {
                ParseResult res = p15.parse(doc, style);
                this.addParserNoticeHighlights(res);
            } else {
                this.clearParserNoticeHighlights(p15);
            }
            this.textArea.fireParserNoticesChange();
        }
        finally {
            doc.readUnlock();
        }
    }

    public int getDelay() {
        return this.timer.getDelay();
    }

    public Parser getParser(int index) {
        return this.parsers.get(index);
    }

    public int getParserCount() {
        return this.parsers.size();
    }

    public List<ParserNotice> getParserNotices() {
        ArrayList<ParserNotice> notices = new ArrayList<ParserNotice>();
        if (this.noticeHighlightPairs != null) {
            for (NoticeHighlightPair pair : this.noticeHighlightPairs) {
                notices.add(pair.notice);
            }
        }
        return notices;
    }

    public ToolTipInfo getToolTipText(MouseEvent e15) {
        String tip = null;
        HyperlinkListener listener = null;
        this.parserForTip = null;
        if (this.noticeHighlightPairs != null) {
            Point p15 = e15.getPoint();
            int pos = this.textArea.viewToModel(p15);
            for (NoticeHighlightPair pair : this.noticeHighlightPairs) {
                ParserNotice notice = pair.notice;
                if (!this.noticeContainsPosition(notice, pos) || !this.noticeContainsPointInView(notice, p15)) continue;
                tip = notice.getToolTipText();
                this.parserForTip = notice.getParser();
                if (!(this.parserForTip instanceof HyperlinkListener)) break;
                listener = (HyperlinkListener)((Object)this.parserForTip);
                break;
            }
        }
        URL imageBase = this.parserForTip == null ? null : this.parserForTip.getImageBase();
        return new ToolTipInfo(tip, listener, imageBase);
    }

    public void handleDocumentEvent(DocumentEvent e15) {
        if (this.running && !this.parsers.isEmpty()) {
            this.timer.restart();
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e15) {
        if (this.parserForTip != null && this.parserForTip.getHyperlinkListener() != null) {
            this.parserForTip.getHyperlinkListener().linkClicked(this.textArea, e15);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e15) {
        try {
            int offs = e15.getOffset();
            if (this.firstOffsetModded == null || offs < this.firstOffsetModded.getOffset()) {
                this.firstOffsetModded = e15.getDocument().createPosition(offs);
            }
            offs = e15.getOffset() + e15.getLength();
            if (this.lastOffsetModded == null || offs > this.lastOffsetModded.getOffset()) {
                this.lastOffsetModded = e15.getDocument().createPosition(offs);
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        this.handleDocumentEvent(e15);
    }

    private boolean noticeContainsPosition(ParserNotice notice, int offs) {
        if (notice.getKnowsOffsetAndLength()) {
            return notice.containsPosition(offs);
        }
        Document doc = this.textArea.getDocument();
        Element root = doc.getDefaultRootElement();
        int line = notice.getLine();
        if (line < 0) {
            return false;
        }
        Element elem = root.getElement(line);
        return elem != null && offs >= elem.getStartOffset() && offs < elem.getEndOffset();
    }

    private boolean noticeContainsPointInView(ParserNotice notice, Point p15) {
        try {
            int end;
            int start;
            if (notice.getKnowsOffsetAndLength()) {
                start = notice.getOffset();
                end = start + notice.getLength() - 1;
            } else {
                Document doc = this.textArea.getDocument();
                Element root = doc.getDefaultRootElement();
                int line = notice.getLine();
                if (line < 0) {
                    return false;
                }
                Element elem = root.getElement(line);
                start = elem.getStartOffset();
                end = elem.getEndOffset() - 1;
            }
            Rectangle r15 = this.textArea.modelToView(start);
            Rectangle r25 = this.textArea.modelToView(end);
            if (r15.y != r25.y) {
                return true;
            }
            --r15.y;
            r15.height += 2;
            return p15.x >= r15.x && p15.x < r25.x + r25.width && p15.y >= r15.y && p15.y < r15.y + r15.height;
        }
        catch (BadLocationException ble) {
            return true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e15) {
        String name = e15.getPropertyName();
        if ("document".equals(name)) {
            RDocument newDoc;
            RDocument old = (RDocument)e15.getOldValue();
            if (old != null) {
                old.removeDocumentListener(this);
            }
            if ((newDoc = (RDocument)e15.getNewValue()) != null) {
                newDoc.addDocumentListener(this);
            }
        }
    }

    public boolean removeParser(Parser parser) {
        this.removeParserNotices(parser);
        boolean removed = this.parsers.remove(parser);
        if (removed) {
            this.textArea.fireParserNoticesChange();
        }
        return removed;
    }

    private void removeParserNotices(Parser parser) {
        if (this.noticeHighlightPairs != null) {
            RSyntaxTextAreaHighlighter h15 = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
            Iterator<NoticeHighlightPair> i15 = this.noticeHighlightPairs.iterator();
            while (i15.hasNext()) {
                NoticeHighlightPair pair = i15.next();
                if (pair.notice.getParser() != parser || pair.highlight == null) continue;
                h15.removeParserHighlight(pair.highlight);
                i15.remove();
            }
        }
    }

    private void removeParserNotices(ParseResult res) {
        if (this.noticeHighlightPairs != null) {
            RSyntaxTextAreaHighlighter h15 = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
            Iterator<NoticeHighlightPair> i15 = this.noticeHighlightPairs.iterator();
            while (i15.hasNext()) {
                NoticeHighlightPair pair = i15.next();
                if (!this.shouldRemoveNotice(pair.notice, res)) continue;
                if (pair.highlight != null) {
                    h15.removeParserHighlight(pair.highlight);
                }
                i15.remove();
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e15) {
        try {
            int offs = e15.getOffset();
            if (this.firstOffsetModded == null || offs < this.firstOffsetModded.getOffset()) {
                this.firstOffsetModded = e15.getDocument().createPosition(offs);
            }
            if (this.lastOffsetModded == null || offs > this.lastOffsetModded.getOffset()) {
                this.lastOffsetModded = e15.getDocument().createPosition(offs);
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        this.handleDocumentEvent(e15);
    }

    public void restartParsing() {
        this.timer.restart();
        this.running = true;
    }

    public void setDelay(int millis) {
        if (this.running) {
            this.timer.stop();
        }
        this.timer.setInitialDelay(millis);
        this.timer.setDelay(millis);
        if (this.running) {
            this.timer.start();
        }
    }

    private boolean shouldRemoveNotice(ParserNotice notice, ParseResult res) {
        return notice.getParser() == res.getParser();
    }

    public void stopParsing() {
        this.timer.stop();
        this.running = false;
    }

    private static class NoticeHighlightPair {
        private ParserNotice notice;
        private RTextAreaHighlighter.HighlightInfo highlight;

        NoticeHighlightPair(ParserNotice notice, RTextAreaHighlighter.HighlightInfo highlight) {
            this.notice = notice;
            this.highlight = highlight;
        }
    }
}

