/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.zipflinger;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import shadow.bundletool.com.android.zipflinger.CentralDirectoryRecord;
import shadow.bundletool.com.android.zipflinger.Entry;
import shadow.bundletool.com.android.zipflinger.ExtractionInfo;
import shadow.bundletool.com.android.zipflinger.Location;
import shadow.bundletool.com.android.zipflinger.ZipWriter;

class CentralDirectory {
    private final ByteBuffer buf;
    private final List<Location> deletedLocations = new ArrayList<Location>();
    private final Map<String, Entry> entries;
    private final Map<String, CentralDirectoryRecord> addedEntries = new LinkedHashMap<String, CentralDirectoryRecord>();

    CentralDirectory(ByteBuffer buf, Map<String, Entry> entries) {
        this.buf = buf;
        this.entries = entries;
    }

    Location delete(String name) {
        if (this.entries.containsKey(name)) {
            Entry entry = this.entries.get(name);
            this.deletedLocations.add(entry.getCdLocation());
            this.entries.remove(name);
            return entry.getLocation();
        }
        if (this.addedEntries.containsKey(name)) {
            CentralDirectoryRecord record = this.addedEntries.remove(name);
            return record.getLocation();
        }
        return Location.INVALID;
    }

    long getNumEntries() {
        return (long)this.entries.size() + (long)this.addedEntries.size();
    }

    void write(ZipWriter writer) throws IOException {
        Collections.sort(this.deletedLocations);
        ArrayList<Location> cleanCDLocations = new ArrayList<Location>();
        long remainingStart = 0L;
        long remainingSize = this.buf.capacity();
        for (Location deletedLocation : this.deletedLocations) {
            Location cleanLoc = new Location(remainingStart, deletedLocation.first - remainingStart);
            if (cleanLoc.size() > 0L) {
                cleanCDLocations.add(cleanLoc);
            }
            remainingStart = deletedLocation.last + 1L;
            remainingSize -= deletedLocation.size() + cleanLoc.size();
        }
        if (remainingSize > 0L) {
            cleanCDLocations.add(new Location(remainingStart, remainingSize));
        }
        for (Location toWrite : cleanCDLocations) {
            this.buf.limit(Math.toIntExact(toWrite.first + toWrite.size()));
            this.buf.position(Math.toIntExact(toWrite.first));
            ByteBuffer view = this.buf.slice();
            writer.write(view);
        }
        long totalSize = 0L;
        for (CentralDirectoryRecord record : this.addedEntries.values()) {
            totalSize += record.getSize();
        }
        ByteBuffer cdBuffer = ByteBuffer.allocate(Math.toIntExact(totalSize)).order(ByteOrder.LITTLE_ENDIAN);
        for (CentralDirectoryRecord record : this.addedEntries.values()) {
            record.write(cdBuffer);
        }
        cdBuffer.rewind();
        writer.write(cdBuffer);
    }

    void add(String name, CentralDirectoryRecord record) {
        this.addedEntries.put(name, record);
    }

    boolean contains(String name) {
        return this.entries.containsKey(name) || this.addedEntries.containsKey(name);
    }

    List<String> listEntries() {
        ArrayList<String> list2 = new ArrayList<String>();
        list2.addAll(this.entries.keySet());
        list2.addAll(this.addedEntries.keySet());
        return list2;
    }

    public ExtractionInfo getExtractionInfo(String name) {
        Entry entry = this.entries.get(name);
        if (entry != null) {
            return new ExtractionInfo(entry.getPayloadLocation(), entry.isCompressed());
        }
        CentralDirectoryRecord cd5 = this.addedEntries.get(name);
        if (cd5 != null) {
            boolean isCompressed = cd5.getCompressionFlag() != 0;
            return new ExtractionInfo(cd5.getPayloadLocation(), isCompressed);
        }
        return null;
    }
}

