/*
 * SPDX-License-Identifier: MPL-2.0
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * For copyright information, see the file debian/copyright.
 */

#ifndef _REL_BASETABLE_H_
#define _REL_BASETABLE_H_

#include "rel_rel.h"

#define is_updateble(rel) \
	(rel->op == op_basetable || \
	(rel->op == op_ddl && (rel->flag == ddl_create_table || rel->flag == ddl_alter_table)))

#define rel_base_table(r) ((sql_table*)r->l)

extern sql_table *rel_ddl_table_get(sql_rel *r);
extern sql_rel *rel_ddl_basetable_get(sql_rel *r);

sql_export sql_rel *rel_basetable(mvc *sql, sql_table *t, const char *tname);
extern void rel_base_copy(mvc *sql, sql_rel *in, sql_rel *out);

extern void rel_base_disallow(sql_rel *r);		/* set flag to check per column access */
extern int rel_base_nid(sql_rel *t, sql_column *c);	/* return error on (read) access violation */
extern int rel_base_idx_nid(sql_rel *t, sql_idx *i);	/* return error on (read) access violation */
extern bool rel_base_has_nid(sql_rel *t, int nid);
extern int rel_base_use(mvc *ql, sql_rel *rt, int nr);	/* return error on (read) access violation */
extern void rel_base_use_tid(mvc *sql, sql_rel *rt);
sql_export void rel_base_use_all(mvc *sql, sql_rel *rel);
extern char *rel_base_name(sql_rel *r);
extern char *rel_base_rename(sql_rel *r, char *name);

extern sql_exp * rel_base_bind_colnr( mvc *sql, sql_rel *rel, int nr);
extern sql_exp * rel_base_find_label( mvc *sql, sql_rel *rel, int label);
extern sql_rel *rel_base_bind_column_( sql_rel *rel, const char *cname);
extern sql_exp *rel_base_bind_column( mvc *sql, sql_rel *rel, const char *cname, int no_tname);
extern sql_rel *rel_base_bind_column2_( sql_rel *rel, const char *tname, const char *cname);
extern sql_exp *rel_base_bind_column2( mvc *sql, sql_rel *rel, const char *tname, const char *cname);
extern sql_exp *rel_base_bind_column3( mvc *sql, sql_rel *rel, const char *sname, const char *tname, const char *cname);
extern sql_column *rel_base_find_column( sql_rel *rel, int nid);

extern list *rel_base_projection( mvc *sql, sql_rel *rel, int intern);
extern list *rel_base_project_all( mvc *sql, sql_rel *rel, char *tname); /* select * from t */
extern sql_rel *rel_base_add_columns( mvc *sql, sql_rel *r);
extern sql_rel *rewrite_basetable(mvc *sql, sql_rel *rel, bool stats);
extern sql_exp *basetable_get_tid_or_add_it(mvc *sql, sql_rel *rel);
extern sql_rel *rel_rename_part(mvc *sql, sql_rel *p, sql_rel *mt_rel, const char *mtalias);

extern void rel_base_dump_exps( stream *fout, sql_rel *rel);
extern int rel_base_has_column_privileges( mvc *sql, sql_rel *rel);

extern void rel_base_set_mergetable( sql_rel *rel, sql_table *mt); /* keep parent merge table */
extern sql_table *rel_base_get_mergetable( sql_rel *rel);

#endif /* _REL_BASETABLE_H_ */
