/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.ubrex;

import com.plantuml.ubrex.Capture;
import com.plantuml.ubrex.Challenge;
import com.plantuml.ubrex.ChallengeResult;
import com.plantuml.ubrex.TextNavigator;

public class ChallengeOneOrMore
implements Challenge {
    private final Challenge origin;

    public ChallengeOneOrMore(Challenge origin) {
        this.origin = origin;
    }

    public String toString() {
        return "ChallengeOneOrMore:" + String.valueOf(this.origin);
    }

    @Override
    public ChallengeResult runChallenge(TextNavigator string, int position) {
        Capture capture = Capture.EMPTY;
        int currentPos = position;
        while (true) {
            ChallengeResult shallWePass;
            if ((shallWePass = this.origin.runChallenge(string, currentPos)).getFullCaptureLength() < 0) {
                if (currentPos > position) {
                    return new ChallengeResult(currentPos - position, capture);
                }
                return new ChallengeResult(Integer.MIN_VALUE);
            }
            if (shallWePass.getFullCaptureLength() == 0) {
                throw new IllegalStateException("infinite loop");
            }
            capture = capture.merge(shallWePass.getCapture());
            currentPos += shallWePass.getFullCaptureLength();
        }
    }
}

