/*
 * Decompiled with CFR 0.152.
 */
package jcckit.graphic;

import java.util.Vector;
import jcckit.graphic.BasicGraphicalElement;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.PolygonRenderer;
import jcckit.graphic.Renderer;

public class Polygon
extends BasicGraphicalElement {
    private final Vector _points = new Vector();
    private final boolean _closed;

    public Polygon(GraphicAttributes attributes, boolean closed) {
        super(attributes);
        this._closed = closed;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    public int getNumberOfPoints() {
        return this._points.size();
    }

    public GraphPoint getPoint(int index) {
        return (GraphPoint)this._points.elementAt(index);
    }

    public void addPoint(GraphPoint point) {
        this._points.addElement(point);
    }

    public void removeAllPoints() {
        this._points.removeAllElements();
    }

    public void replacePointAt(int index, GraphPoint point) {
        this._points.setElementAt(point, index);
    }

    @Override
    public void renderWith(Renderer renderer) {
        if (!(renderer instanceof PolygonRenderer)) {
            throw new IllegalArgumentException(String.valueOf(renderer) + " does not implements PolygonRenderer.");
        }
        ((PolygonRenderer)renderer).render(this);
    }
}

