/*
 * Decompiled with CFR 0.152.
 */
package net.atmp;

import java.util.Objects;
import net.sourceforge.plantuml.klimt.AffineTransformType;
import net.sourceforge.plantuml.klimt.MutableImage;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import net.sourceforge.plantuml.klimt.awt.PortableImageFactory;
import net.sourceforge.plantuml.klimt.awt.XColor;
import net.sourceforge.plantuml.klimt.color.ColorUtils;

public class PixelImage
implements MutableImage {
    private final PortableImage imageScale1;
    private final double scale;
    private final AffineTransformType type;
    private PortableImage cache = null;
    private static final int mask_a__ = -16777216;
    private static final int mask_rgb = 0xFFFFFF;

    public PixelImage(PortableImage image, AffineTransformType type) {
        this(image, type, 1.0);
    }

    private PixelImage(PortableImage image, AffineTransformType type, double scale) {
        this.imageScale1 = image;
        this.scale = scale;
        this.type = Objects.requireNonNull(type);
    }

    @Override
    public MutableImage withScale(double scale) {
        return new PixelImage(this.imageScale1, this.type, this.scale * scale);
    }

    @Override
    public final PortableImage getImage() {
        if (this.scale == 1.0) {
            return this.imageScale1;
        }
        if (this.cache == null) {
            this.cache = this.imageScale1.scale(this.scale, this.type.toLegacyInt());
        }
        return this.cache;
    }

    @Override
    public MutableImage monochrome() {
        PortableImage copy = this.deepCopy();
        for (int i = 0; i < this.imageScale1.getWidth(); ++i) {
            for (int j = 0; j < this.imageScale1.getHeight(); ++j) {
                int color = this.imageScale1.getRGB(i, j);
                int rgb = this.getRgb(color);
                int grayScale = ColorUtils.getGrayScaleFromRGB(rgb);
                int gray = grayScale + grayScale << 8 + grayScale << 16;
                int a = this.getA(color);
                copy.setRGB(i, j, gray + a);
            }
        }
        return new PixelImage(copy, this.type, this.scale);
    }

    @Override
    public MutableImage muteColor(XColor newColor) {
        if (newColor == null) {
            return this;
        }
        int darkerRgb = this.getDarkerRgb();
        PortableImage copy = this.deepCopy();
        for (int i = 0; i < this.imageScale1.getWidth(); ++i) {
            for (int j = 0; j < this.imageScale1.getHeight(); ++j) {
                int color = this.imageScale1.getRGB(i, j);
                int rgb = this.getRgb(color);
                int a = this.getA(color);
                if (a == 0 || rgb != darkerRgb) continue;
                copy.setRGB(i, j, newColor.getRGB() + a);
            }
        }
        return new PixelImage(copy, this.type, this.scale);
    }

    @Override
    public MutableImage muteTransparentColor(XColor newColor) {
        if (newColor == null) {
            newColor = XColor.WHITE;
        }
        PortableImage copy = this.deepCopy();
        for (int i = 0; i < this.imageScale1.getWidth(); ++i) {
            for (int j = 0; j < this.imageScale1.getHeight(); ++j) {
                int color = this.imageScale1.getRGB(i, j);
                int a = this.getA(color);
                if (a != 0) continue;
                copy.setRGB(i, j, newColor.getRGB());
            }
        }
        return new PixelImage(copy, this.type, this.scale);
    }

    private int getDarkerRgb() {
        int darkerRgb = -1;
        for (int i = 0; i < this.imageScale1.getWidth(); ++i) {
            for (int j = 0; j < this.imageScale1.getHeight(); ++j) {
                int color = this.imageScale1.getRGB(i, j);
                int rgb = this.getRgb(color);
                int a = this.getA(color);
                if (a != -16777216) continue;
                int gray = ColorUtils.getGrayScaleFromRGB(rgb);
                if (darkerRgb != -1 && gray >= ColorUtils.getGrayScaleFromRGB(darkerRgb)) continue;
                darkerRgb = rgb;
            }
        }
        return darkerRgb;
    }

    private int getRgb(int color) {
        return color & 0xFFFFFF;
    }

    private int getA(int color) {
        return color & 0xFF000000;
    }

    private PortableImage deepCopy() {
        PortableImage result = PortableImageFactory.build(this.imageScale1.getWidth(), this.imageScale1.getHeight(), 2);
        for (int i = 0; i < this.imageScale1.getWidth(); ++i) {
            for (int j = 0; j < this.imageScale1.getHeight(); ++j) {
                result.setRGB(i, j, this.imageScale1.getRGB(i, j));
            }
        }
        return result;
    }

    @Override
    public final double getScale() {
        return this.scale;
    }
}

