/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.nio.PathSystem;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.UncommentReadLine;
import net.sourceforge.plantuml.preproc2.Preprocessor;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.utils.StartUtils;

public final class BlockUmlBuilder
implements DefinitionsContainer {
    private final List<BlockUml> blocks = new ArrayList<BlockUml>();
    private Set<File> usedFiles = new HashSet<File>();
    private final PathSystem pathSystem;
    private final Charset charset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockUmlBuilder(List<String> config, Charset charset, Defines defines, Reader readerInit, SFile newCurrentDir, String desc) throws IOException {
        this.charset = Objects.requireNonNull(charset);
        UncommentReadLine reader = new UncommentReadLine(ReadLineReader.create(readerInit, desc));
        this.pathSystem = PathSystem.fetch().changeCurrentDirectory(newCurrentDir);
        try (Preprocessor includer = new Preprocessor(config, reader);){
            StringLocated s = null;
            ArrayList<StringLocated> current = null;
            boolean paused = false;
            while ((s = includer.readLine()) != null) {
                StringLocated append;
                if (StartUtils.isArobaseStartDiagram(s.getString())) {
                    current = new ArrayList<StringLocated>();
                    paused = false;
                }
                if (StartUtils.isArobasePauseDiagram(s.getString())) {
                    paused = true;
                    reader.setPaused(true);
                }
                if (StartUtils.isExit(s.getString())) {
                    paused = true;
                    reader.setPaused(true);
                }
                if (current != null && !paused) {
                    current.add(s);
                } else if (paused && (append = StartUtils.getPossibleAppend(s)) != null) {
                    current.add(append);
                }
                if (StartUtils.isArobaseUnpauseDiagram(s.getString())) {
                    paused = false;
                    reader.setPaused(false);
                }
                if (!StartUtils.isArobaseEndDiagram(s.getString()) || current == null) continue;
                if (paused) {
                    current.add(s);
                }
                BlockUml uml = new BlockUml(this, this.pathSystem, current, defines.cloneMe(), null, charset);
                this.usedFiles.addAll(uml.getIncluded());
                this.blocks.add(uml);
                current = null;
                reader.setPaused(false);
            }
        }
        finally {
            readerInit.close();
        }
    }

    public List<BlockUml> getBlockUmls() {
        return Collections.unmodifiableList(this.blocks);
    }

    public final Set<File> getIncludedFiles() {
        return this.usedFiles;
    }

    @Override
    public List<String> getDefinition(String name) {
        for (BlockUml block : this.blocks) {
            if (!block.isStartDef(name)) continue;
            return block.getDefinition(false);
        }
        return Collections.emptyList();
    }

    @Override
    @Deprecated
    public final String getCharset() {
        return this.charset.name();
    }

    @Override
    public PathSystem getPathSystem() {
        return this.pathSystem;
    }
}

