/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.dot.GraphvizUtils;
import net.sourceforge.plantuml.klimt.UAntiAliasing;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import net.sourceforge.plantuml.klimt.awt.PortableImageFactory;
import net.sourceforge.plantuml.klimt.awt.XColor;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.utils.Log;

public class EmptyImageBuilder {
    private final PortableImage im;
    private final Graphics2D g2d;

    public EmptyImageBuilder(String watermark, int width, int height, XColor background, StringBounder stringBounder) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        if (width > GraphvizUtils.getenvImageLimit()) {
            int width2 = width;
            Log.info(() -> "Width too large " + width2 + ". You should set PLANTUML_LIMIT_SIZE");
            width = GraphvizUtils.getenvImageLimit();
        }
        if (height > GraphvizUtils.getenvImageLimit()) {
            int height2 = height;
            Log.info(() -> "Height too large " + height2 + ". You should set PLANTUML_LIMIT_SIZE");
            height = GraphvizUtils.getenvImageLimit();
        }
        int widthFinal = width;
        int heightFinal = height;
        int type = this.getType(background);
        Log.info(() -> "Creating image " + widthFinal + "x" + heightFinal + " type=" + type);
        this.im = PortableImageFactory.build(width, height, type);
        this.g2d = this.im.createGraphics();
        UAntiAliasing.ANTI_ALIASING_ON.apply(this.g2d);
        if (background != null) {
            this.g2d.setColor(background.toAwtColor());
            this.g2d.fillRect(0, 0, width, height);
        }
        if (watermark != null) {
            int gray = 200;
            this.g2d.setColor(new XColor(200, 200, 200).toAwtColor());
            this.printWatermark(watermark, width, height);
        }
    }

    private int getType(XColor background) {
        if (background == null) {
            return 2;
        }
        if (background.getAlpha() != 255) {
            return 2;
        }
        return 1;
    }

    private void printWatermark(String watermark, int maxWidth, int maxHeight) {
        Font javaFont = this.g2d.getFont();
        FontMetrics fm = this.g2d.getFontMetrics(javaFont);
        Rectangle2D rect = fm.getStringBounds(watermark, this.g2d);
        int height = (int)rect.getHeight();
        int width = (int)rect.getWidth();
        if (height < 2 || width < 2) {
            return;
        }
        if (width <= maxWidth) {
            for (int y = height; y < maxHeight; y += height + 1) {
                for (int x = 0; x < maxWidth; x += width + 10) {
                    this.g2d.drawString(watermark, x, y);
                }
            }
        } else {
            List<String> withBreaks = this.withBreaks(watermark, javaFont, fm, maxWidth);
            for (int y = 0; y < maxHeight; y += 10) {
                for (String s : withBreaks) {
                    this.g2d.drawString(s, 0, y);
                    y += (int)fm.getStringBounds(s, this.g2d).getHeight();
                }
            }
        }
    }

    private int getWidth(String line, Font javaFont, FontMetrics fm) {
        Rectangle2D rect = fm.getStringBounds(line, this.g2d);
        return (int)rect.getWidth();
    }

    private List<String> withBreaks(String watermark, Font javaFont, FontMetrics fm, int maxWidth) {
        String[] words = watermark.split("\\s+");
        ArrayList<String> result = new ArrayList<String>();
        String pending = "";
        for (String word : words) {
            String candidate;
            String string = candidate = pending.length() == 0 ? word : pending + " " + word;
            if (this.getWidth(candidate, javaFont, fm) < maxWidth) {
                pending = candidate;
                continue;
            }
            result.add(pending);
            pending = word;
        }
        if (pending.length() > 0) {
            result.add(pending);
        }
        return result;
    }

    public Graphics2D getGraphics2D() {
        return this.g2d;
    }

    public PortableImage getPortableImage() {
        return this.im;
    }
}

