/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.ISourceFileReader;
import net.sourceforge.plantuml.SourceFileReaderAbstract;
import net.sourceforge.plantuml.file.SuggestedFile;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.utils.Log;

public class SourceFileReaderCopyCat
extends SourceFileReaderAbstract
implements ISourceFileReader {
    private final File outputDirectory;

    public SourceFileReaderCopyCat(boolean ignoreSuggestedName, Defines defines, File file, File outputDirectory, List<String> config, String charset, FileFormatOption fileFormatOption) throws IOException {
        super(ignoreSuggestedName, file, fileFormatOption, defines, config, charset);
        String path = file.getParentFile().getPath();
        this.outputDirectory = new File(outputDirectory, path).getAbsoluteFile();
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
    }

    @Override
    protected SuggestedFile getSuggestedFile(BlockUml blockUml) {
        String newName;
        String string = newName = this.ignoreSuggestedName ? null : blockUml.getFileOrDirname();
        if (newName == null) {
            newName = this.getFileName();
        }
        SuggestedFile suggested = this.getSuggestedFile(this.outputDirectory, newName);
        Log.info(() -> "We are going to put data in " + String.valueOf(suggested));
        suggested.getParentFile().mkdirs();
        return suggested;
    }
}

