/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.abel;

import java.util.Objects;
import net.atmp.CucaDiagram;
import net.sourceforge.plantuml.abel.CucaNote;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.EntityPosition;
import net.sourceforge.plantuml.abel.Hideable;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.LinkArg;
import net.sourceforge.plantuml.abel.LinkArrow;
import net.sourceforge.plantuml.abel.LinkStrategy;
import net.sourceforge.plantuml.abel.NoteLinkStrategy;
import net.sourceforge.plantuml.abel.Removeable;
import net.sourceforge.plantuml.cucadiagram.EntityPort;
import net.sourceforge.plantuml.cucadiagram.LinkConstraint;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.decoration.WithLinkType;
import net.sourceforge.plantuml.decoration.symbol.USymbolInterface;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UComment;
import net.sourceforge.plantuml.skin.PragmaKey;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinSimple;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.utils.LineLocation;

public class Link
extends WithLinkType
implements Hideable,
Removeable {
    private final Entity cl1;
    private final Entity cl2;
    private String port1;
    private String port2;
    private final LinkArg linkArg;
    private final String uid;
    private CucaNote note;
    private boolean invis = false;
    private double weight = 1.0;
    private boolean constraint = true;
    private boolean inverted = false;
    private LinkArrow linkArrow = LinkArrow.NONE_OR_SEVERAL;
    private boolean opale;
    private boolean horizontalSolitary;
    private String sametail;
    private final StyleBuilder styleBuilder;
    private Stereotype stereotype;
    private final CucaDiagram cucaDiagram;
    private final LineLocation location;
    private Url url;
    private LinkConstraint linkConstraint;
    private LineLocation codeLine;

    public final StyleBuilder getStyleBuilder() {
        return this.styleBuilder;
    }

    public LinkStrategy getLinkStrategy() {
        return LinkStrategy.SIMPLIER;
    }

    public String idCommentForSvg() {
        if (this.type.looksLikeRevertedForSvg()) {
            return this.getEntity1().getName() + "-backto-" + this.getEntity2().getName();
        }
        if (this.type.looksLikeNoDecorAtAllSvg()) {
            return this.getEntity1().getName() + "-" + this.getEntity2().getName();
        }
        return this.getEntity1().getName() + "-to-" + this.getEntity2().getName();
    }

    public UComment commentForSvg() {
        if (this.type.looksLikeRevertedForSvg()) {
            return new UComment("reverse link " + this.getEntity1().getName() + " to " + this.getEntity2().getName());
        }
        return new UComment("link " + this.getEntity1().getName() + " to " + this.getEntity2().getName());
    }

    public Link(LineLocation location, CucaDiagram cucaDiagram, StyleBuilder styleBuilder, Entity cl1, Entity cl2, LinkType type, LinkArg linkArg) {
        if (linkArg.getLength() < 1) {
            throw new IllegalArgumentException();
        }
        this.location = location;
        this.cucaDiagram = cucaDiagram;
        this.styleBuilder = styleBuilder;
        this.cl1 = Objects.requireNonNull(cl1);
        this.cl2 = Objects.requireNonNull(cl2);
        this.type = type;
        this.uid = cucaDiagram.getUniqueSequence("lnk");
        this.linkArg = linkArg;
        if (cucaDiagram.getPragma().isTrue(PragmaKey.KERMOR) && !cl1.getEntityPosition().isNormal() ^ !cl2.getEntityPosition().isNormal()) {
            this.setConstraint(false);
        }
    }

    public Link getInv() {
        Link result = new Link(this.location, this.cucaDiagram, this.styleBuilder, this.cl2, this.cl1, this.getType().getInversed(), this.linkArg.getInv());
        result.inverted = !this.inverted;
        result.port1 = this.port2;
        result.port2 = this.port1;
        result.url = this.url;
        result.linkConstraint = this.linkConstraint;
        result.stereotype = this.stereotype;
        result.linkArg.setVisibilityModifier(this.linkArg.getVisibilityModifier());
        result.linkArrow = this.linkArrow;
        return result;
    }

    @Override
    public void goNorank() {
        this.setConstraint(false);
    }

    public String getLabeldistance() {
        return this.getLinkArg().getLabeldistance();
    }

    public String getLabelangle() {
        return this.getLinkArg().getLabelangle();
    }

    public String getUid() {
        return this.uid;
    }

    public final boolean isInvis() {
        if (this.type.isInvisible()) {
            return true;
        }
        return this.invis;
    }

    public final void setInvis(boolean invis) {
        this.invis = invis;
    }

    public boolean isBetween(Entity cl1, Entity cl2) {
        if (cl1 == this.cl1 && cl2 == this.cl2) {
            return true;
        }
        return cl1 == this.cl2 && cl2 == this.cl1;
    }

    public String toString() {
        return super.toString() + " {" + this.linkArg.getLength() + "} " + String.valueOf(this.cl1) + "-->" + String.valueOf(this.cl2);
    }

    public Entity getEntity1() {
        return this.cl1;
    }

    public Entity getEntity2() {
        return this.cl2;
    }

    public String getPortName1() {
        return this.port1;
    }

    public String getPortName2() {
        return this.port2;
    }

    public EntityPort getEntityPort1(Bibliotekon bibliotekon) {
        return this.getEntityPort(this.cl1, this.port1, bibliotekon);
    }

    public EntityPort getEntityPort2(Bibliotekon bibliotekon) {
        return this.getEntityPort(this.cl2, this.port2, bibliotekon);
    }

    private EntityPort getEntityPort(Entity leaf, String port, Bibliotekon bibliotekon) {
        if (leaf.getEntityPosition().usePortP()) {
            return EntityPort.forPort(bibliotekon.getNodeUid(leaf));
        }
        return EntityPort.create(bibliotekon.getNodeUid(leaf), port);
    }

    @Override
    public LinkType getType() {
        if (this.opale) {
            return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        }
        if (this.getSametail() != null) {
            return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        }
        LinkType result = this.type;
        return result;
    }

    private boolean isReallyGroup(Entity ent) {
        if (!ent.isGroup()) {
            return false;
        }
        Entity group = ent;
        return group.groups().size() + group.leafs().size() > 0;
    }

    public LinkType getTypePatchCluster() {
        LinkType result = this.getType();
        if (this.isReallyGroup(this.getEntity1())) {
            result = result.withoutDecors2();
        }
        if (this.isReallyGroup(this.getEntity2())) {
            result = result.withoutDecors1();
        }
        return result;
    }

    private LinkType getTypeSpecialForPrinting() {
        if (this.opale) {
            return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        }
        LinkType result = this.type;
        return result;
    }

    private boolean isLollipopInterfaceEye(Entity ent) {
        return ent.getUSymbol() instanceof USymbolInterface;
    }

    public Display getLabel() {
        return this.getLinkArg().getLabel();
    }

    public int getLength() {
        return this.getLinkArg().getLength();
    }

    public final void setLength(int length) {
        this.getLinkArg().setLength(length);
    }

    public String getQuantifier1() {
        return this.getLinkArg().getQuantifier1();
    }

    public String getQuantifier2() {
        return this.getLinkArg().getQuantifier2();
    }

    public String getRole1() {
        return this.getLinkArg().getRole1();
    }

    public String getRole2() {
        return this.getLinkArg().getRole2();
    }

    public final double getWeight() {
        return this.weight;
    }

    public final void setWeight(double weight) {
        this.weight = weight;
    }

    public final CucaNote getNote() {
        return this.note;
    }

    public final void addNote(CucaNote note) {
        this.note = note;
    }

    public final void addNoteFrom(Link other, NoteLinkStrategy strategy) {
        if (other.note != null) {
            this.note = other.note.withStrategy(strategy);
        }
    }

    public boolean isAutoLinkOfAGroup() {
        if (!this.getEntity1().isGroup()) {
            return false;
        }
        if (!this.getEntity2().isGroup()) {
            return false;
        }
        return this.getEntity1() == this.getEntity2();
    }

    public boolean containsType(LeafType type) {
        return this.getEntity1().getLeafType() == type || this.getEntity2().getLeafType() == type;
    }

    public boolean contains(Entity entity) {
        if (this.getEntity1() == entity) {
            return true;
        }
        return this.getEntity2() == entity;
    }

    public Entity getOther(Entity entity) {
        if (this.getEntity1() == entity) {
            return this.getEntity2();
        }
        if (this.getEntity2() == entity) {
            return this.getEntity1();
        }
        throw new IllegalArgumentException();
    }

    private double getQuantifierMargin(StringBounder stringBounder, UFont fontQualif, String qualif, ISkinSimple spriteContainer) {
        if (qualif != null) {
            TextBlock b = Display.create(qualif).create(FontConfiguration.blackBlueTrue(fontQualif), HorizontalAlignment.LEFT, spriteContainer);
            XDimension2D dim = b.calculateDimension(stringBounder);
            return Math.max(dim.getWidth(), dim.getHeight());
        }
        return 0.0;
    }

    public final boolean isConstraint() {
        return this.constraint;
    }

    public final void setConstraint(boolean constraint) {
        this.constraint = constraint;
    }

    public void setOpale(boolean opale) {
        this.opale = opale;
    }

    public final void setHorizontalSolitary(boolean horizontalSolitary) {
        this.horizontalSolitary = horizontalSolitary;
    }

    public final boolean isHorizontalSolitary() {
        return this.horizontalSolitary;
    }

    public final LinkArrow getLinkArrow() {
        if (this.inverted) {
            return this.linkArrow.reverse();
        }
        return this.linkArrow;
    }

    public final void setLinkArrow(LinkArrow linkArrow) {
        this.linkArrow = linkArrow;
    }

    public final boolean isInverted() {
        return this.inverted;
    }

    public boolean hasEntryPoint() {
        return !this.getEntity1().isGroup() && this.getEntity1().getEntityPosition() != EntityPosition.NORMAL || !this.getEntity2().isGroup() && this.getEntity2().getEntityPosition() != EntityPosition.NORMAL;
    }

    public boolean hasTwoEntryPointsSameContainer() {
        return !this.getEntity1().isGroup() && !this.getEntity2().isGroup() && this.getEntity1().getEntityPosition() != EntityPosition.NORMAL && this.getEntity2().getEntityPosition() != EntityPosition.NORMAL && this.getEntity1().getParentContainer() == this.getEntity2().getParentContainer();
    }

    public Url getUrl() {
        return this.url;
    }

    public void setUrl(Url url) {
        this.url = url;
    }

    @Override
    public boolean isHidden() {
        return this.hidden || this.cl1.isHidden() || this.cl2.isHidden();
    }

    public boolean sameConnections(Link other) {
        if (this.cl1 == other.cl1 && this.cl2 == other.cl2) {
            return true;
        }
        return this.cl1 == other.cl2 && this.cl2 == other.cl1;
    }

    public boolean doesTouch(Link other) {
        if (this.cl1 == other.cl1) {
            return true;
        }
        if (this.cl1 == other.cl2) {
            return true;
        }
        if (this.cl2 == other.cl1) {
            return true;
        }
        return this.cl2 == other.cl2;
    }

    public boolean isAutolink() {
        return this.cl1 == this.cl2;
    }

    @Override
    public boolean isRemoved() {
        Stereotype stereotype = this.getStereotype();
        if (stereotype != null && this.cucaDiagram.isStereotypeRemoved(stereotype)) {
            return true;
        }
        return this.cl1.isRemoved() || this.cl2.isRemoved();
    }

    public boolean hasUrl() {
        if (!Display.isNull(this.linkArg.getLabel()) && this.linkArg.getLabel().hasUrl()) {
            return true;
        }
        return this.getUrl() != null;
    }

    public String getSametail() {
        return this.sametail;
    }

    public void setSametail(String sametail) {
        this.sametail = sametail;
    }

    public void setPortMembers(String port1, String port2) {
        this.port1 = port1;
        this.port2 = port2;
        if (port1 != null) {
            this.cl1.addPortShortName(port1);
        }
        if (port2 != null) {
            this.cl2.addPortShortName(port2);
        }
    }

    public void setLinkConstraint(LinkConstraint linkConstraint) {
        this.linkConstraint = linkConstraint;
    }

    public final LinkConstraint getLinkConstraint() {
        return this.linkConstraint;
    }

    public String getCodeLine() {
        if (this.codeLine == null) {
            return null;
        }
        return "" + this.codeLine.getPosition();
    }

    public void setCodeLine(LineLocation location) {
        this.codeLine = location;
    }

    public void setStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
    }

    public final Stereotype getStereotype() {
        return this.stereotype;
    }

    public final LinkArg getLinkArg() {
        return this.linkArg;
    }

    public final VisibilityModifier getVisibilityModifier() {
        return this.getLinkArg().getVisibilityModifier();
    }

    public final boolean isOpale() {
        return this.opale;
    }

    public final boolean hasKal1() {
        return this.linkArg.getKal1() != null && !this.linkArg.getKal1().isEmpty();
    }

    public final boolean hasKal2() {
        return this.linkArg.getKal2() != null && !this.linkArg.getKal2().isEmpty();
    }

    public LineLocation getLocation() {
        return this.location;
    }
}

