/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereogroup;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.url.UrlMode;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.warning.Warning;

public class CommandActivity3
extends SingleLineCommand2<ActivityDiagram3> {
    public CommandActivity3() {
        super(CommandActivity3.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandActivity3.class.getName(), RegexLeaf.start(), UrlBuilder.OPTIONAL, CommandActivity3.color().getRegex(), StereotypePattern.optional("IGNORED"), new RegexLeaf(":"), new RegexLeaf(1, "LABEL", "(.*?)"), new RegexLeaf(";"), RegexLeaf.spaceZeroOrMore(), Stereogroup.optionalStereogroup(), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram3 diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        Url url;
        if (arg.get("URL", 0) == null) {
            url = null;
        } else {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            url = urlBuilder.getUrl(arg.get("URL", 0));
        }
        Stereogroup stereogroup = Stereogroup.build(arg);
        Colors colors = stereogroup.getColors(diagram.getSkinParam().getIHtmlColorSet());
        if (arg.get("IGNORED", 0) != null) {
            diagram.addWarning(new Warning("You must use stereotype at the end of the line after the ';'"));
        }
        if (arg.get("COLOR", 0) != null) {
            diagram.addWarning(new Warning("This syntax is deprecated, you must add <<" + arg.get("COLOR", 0) + ">> at the end of the line, after the ';'"));
        }
        Stereotype stereotype = stereogroup.buildStereotype();
        BoxStyle style = stereogroup.getBoxStyle();
        Display display = Display.getWithNewlines2(diagram.getPragma(), arg.get("LABEL", 0));
        return diagram.addActivity(display, style, url, colors, stereotype);
    }
}

