/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleAcceptEvent;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleContinuous;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleInput;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleLoad;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleObject;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleObjectSignal;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleOutput;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStylePlain;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleProcedure;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleSave;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleSendSignal;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleTask;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleTimeEvent;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyleTrigger;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.stereo.Stereotype;

public abstract class BoxStyle {
    private static final List<BoxStyle> values = new ArrayList<BoxStyle>();
    public static final BoxStyle PLAIN = new BoxStylePlain(null, 0.0);
    public static final BoxStyle SDL_INPUT = new BoxStyleInput("input", 10.0);
    public static final BoxStyle SDL_OUTPUT = new BoxStyleOutput("output", 10.0);
    public static final BoxStyle SDL_PROCEDURE = new BoxStyleProcedure("procedure", 0.0);
    public static final BoxStyle SDL_LOAD = new BoxStyleLoad("load", 0.0);
    public static final BoxStyle SDL_SAVE = new BoxStyleSave("save", 0.0);
    public static final BoxStyle SDL_CONTINUOUS = new BoxStyleContinuous("continuous", 0.0);
    public static final BoxStyle SDL_TASK = new BoxStyleTask("task", 0.0);
    public static final BoxStyle UML_OBJECT = new BoxStyleObject("object", 0.0);
    public static final BoxStyle UML_OBJECT_SIGNAL = new BoxStyleObjectSignal("objectSignal", 10.0);
    public static final BoxStyle UML_TRIGGER = new BoxStyleTrigger("trigger", 10.0);
    public static final BoxStyle UML_SEND_SIGNAL = new BoxStyleSendSignal("sendSignal", 10.0);
    public static final BoxStyle UML_ACCEPT_EVENT = new BoxStyleAcceptEvent("acceptEvent", 10.0);
    public static final BoxStyle UML_TIME_EVENT = new BoxStyleTimeEvent("timeEvent", 10.0);
    protected final String stereotype;
    protected final double shield;
    protected static int DELTA_INPUT_OUTPUT = 10;
    protected static double DELTA_CONTINUOUS = 5.0;
    protected static int PADDING = 5;

    public abstract void drawMe(UGraphic var1, double var2, double var4, double var6, double var8);

    protected BoxStyle(String stereotype, double shield) {
        this.stereotype = stereotype;
        this.shield = shield;
        values.add(this);
    }

    public double getShield() {
        return this.shield;
    }

    public static BoxStyle fromString(String style) {
        style = style.replaceAll("-", "");
        for (BoxStyle bs : values) {
            if (!style.equalsIgnoreCase(bs.stereotype)) continue;
            return bs;
        }
        return PLAIN;
    }

    public Stereotype getStereotype() {
        if (this.stereotype == null) {
            return null;
        }
        return Stereotype.build("<<" + this.stereotype + ">>");
    }

    public void drawMeDebug(UGraphic ug, double width, double height, double shadowing, double roundCorner) {
        URectangle s = URectangle.build(width, height);
        s.setDeltaShadow(shadowing);
        ug.draw(s);
    }
}

