/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.bpm;

import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBox;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileCircleStart;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.bpm.AbstractConnectorPuzzle;
import net.sourceforge.plantuml.bpm.BpmElementType;
import net.sourceforge.plantuml.bpm.ConnectorPuzzle;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.font.UFontFactory;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.skin.ColorParam;
import net.sourceforge.plantuml.skin.SkinParamUtils;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class BpmElement
extends AbstractConnectorPuzzle
implements ConnectorPuzzle {
    private final String id;
    private final BpmElementType type;
    private final Display display;
    private XDimension2D dimension;

    public BpmElement(String id, BpmElementType type, String label) {
        this.id = id;
        this.type = type;
        this.display = Display.getWithNewlines(this.getPragma(), label);
    }

    public BpmElement(String id, BpmElementType type) {
        this(id, type, null);
    }

    public String toString() {
        if (this.id == null) {
            return this.type.toString() + "(" + String.valueOf(this.display) + ")";
        }
        return this.type.toString() + "(" + this.id + ")";
    }

    public BpmElementType getType() {
        return this.type;
    }

    public final Display getDisplay() {
        return this.display;
    }

    @Override
    public TextBlock toTextBlock(ISkinParam skinParam) {
        final TextBlock raw = this.toTextBlockInternal(skinParam);
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                raw.drawU(ug);
                ug = ug.apply(HColors.RED);
                for (ConnectorPuzzle.Where w : ConnectorPuzzle.Where.values()) {
                    if (!BpmElement.this.have(w)) continue;
                    BpmElement.this.drawLine(ug, w, raw.calculateDimension(ug.getStringBounder()));
                }
            }

            @Override
            public XRectangle2D getInnerPosition(CharSequence member, StringBounder stringBounder) {
                return raw.getInnerPosition(member, stringBounder);
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return raw.calculateDimension(stringBounder);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                return raw.getMinMax(stringBounder);
            }
        };
    }

    private void drawLine(UGraphic ug, ConnectorPuzzle.Where w, XDimension2D total) {
        double width = total.getWidth();
        double height = total.getHeight();
        if (w == ConnectorPuzzle.Where.WEST) {
            ug.apply(new UTranslate(-10.0, height / 2.0)).draw(ULine.hline(10.0));
        }
        if (w == ConnectorPuzzle.Where.EAST) {
            ug.apply(new UTranslate(width, height / 2.0)).draw(ULine.hline(10.0));
        }
        if (w == ConnectorPuzzle.Where.NORTH) {
            ug.apply(new UTranslate(width / 2.0, -10.0)).draw(ULine.vline(10.0));
        }
        if (w == ConnectorPuzzle.Where.SOUTH) {
            ug.apply(new UTranslate(width / 2.0, height)).draw(ULine.vline(10.0));
        }
    }

    private StyleSignatureBasic getSignatureCircle() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.circle);
    }

    private Style getStyle(ISkinParam skinParam) {
        return this.getSignatureCircle().getMergedStyle(skinParam.getCurrentStyleBuilder());
    }

    public TextBlock toTextBlockInternal(ISkinParam skinParam) {
        if (this.type == BpmElementType.START) {
            return new FtileCircleStart(skinParam, null, this.getStyle(skinParam), Colors.empty());
        }
        if (this.type == BpmElementType.MERGE) {
            HColor borderColor = SkinParamUtils.getColor(skinParam, null, ColorParam.activityBorder);
            HColor backColor = SkinParamUtils.getColor(skinParam, null, ColorParam.activityBackground);
            return new FtileDiamond(skinParam, backColor, borderColor, null);
        }
        if (this.type == BpmElementType.DOCKED_EVENT) {
            UFont font = UFontFactory.serif(14);
            return FtileBox.create(skinParam, this.display, null, BoxStyle.PLAIN, null, null);
        }
        UFont font = UFontFactory.serif(14);
        FontConfiguration fc = FontConfiguration.create(font, HColors.RED, HColors.RED, null);
        if (Display.isNull(this.display)) {
            return Display.getWithNewlines(skinParam.getPragma(), this.type.toString()).create(fc, HorizontalAlignment.LEFT, skinParam);
        }
        return this.display.create(fc, HorizontalAlignment.LEFT, skinParam);
    }

    @Override
    public XDimension2D getDimension(StringBounder stringBounder, ISkinParam skinParam) {
        if (this.dimension == null) {
            this.dimension = this.toTextBlock(skinParam).calculateDimension(stringBounder);
        }
        return this.dimension;
    }

    @Override
    public final String getId() {
        return this.id;
    }
}

