/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chronology;

import java.time.LocalDate;
import net.sourceforge.plantuml.chronology.TimeHeader2;
import net.sourceforge.plantuml.chronology.TimeHeaderParameters2;
import net.sourceforge.plantuml.chronology.TimeScaleChronology;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.project.core.PrintScale;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;

public class TimeHeaderChronology
extends TimeHeader2 {
    private final PrintScale printScale;

    @Override
    public double getFullHeaderHeight(StringBounder stringBounder) {
        return this.getTimeHeaderHeight(stringBounder) + this.getHeaderNameDayHeight();
    }

    @Override
    public double getTimeHeaderHeight(StringBounder stringBounder) {
        double h = this.thParam.getStyle(SName.timeline, SName.day).value(PName.FontSize).asDouble();
        return h + 6.0;
    }

    @Override
    public double getTimeFooterHeight(StringBounder stringBounder) {
        double h = this.thParam.getStyle(SName.timeline, SName.day).value(PName.FontSize).asDouble();
        return h + 6.0;
    }

    private double getHeaderNameDayHeight() {
        return 0.0;
    }

    public TimeHeaderChronology(StringBounder stringBounder, TimeHeaderParameters2 thParam, PrintScale printScale, TimeScaleChronology timeScale) {
        super(thParam, timeScale);
        this.printScale = printScale;
    }

    private void drawSmallVlinesDay(UGraphic ug, TimeScale timeScale, double totalHeightWithoutFooter) {
        ug = ug.apply(this.getLineColor());
        ug = ug.apply(UTranslate.dy(6.0));
        ULine vbar = ULine.vline(totalHeightWithoutFooter + 2.0);
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay()) <= 0) {
            TimePoint wink = TimePoint.ofStartOfDay(day);
            double x1 = timeScale.getPosition(wink);
            ug.apply(UTranslate.dx(x1)).draw(vbar);
            day = day.plusDays(1L);
        }
    }

    private void drawSimpleDayCounter(UGraphic ug, TimeScale timeScale) {
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay()) < 0) {
            TimePoint wink = TimePoint.ofStartOfDay(day);
            UFont font = this.thParam.getStyle(SName.timeline, SName.day).getUFont();
            FontConfiguration fontConfiguration = this.getFontConfiguration(font, false, this.openFontColor());
            TextBlock num = Display.getWithNewlines(this.getPragma(), wink.toStringShort(this.thParam.getLocale())).create(fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            double x1 = timeScale.getPosition(wink);
            double x2 = this.printScale == PrintScale.WEEKLY ? timeScale.getPosition(wink.addDays(6)) : timeScale.getPosition(wink);
            double width = num.calculateDimension(ug.getStringBounder()).getWidth();
            double delta = x2 - x1 - width;
            if (wink.compareTo(TimePoint.ofStartOfDay(this.getMaxDay().plusDays(1L))) < 0) {
                num.drawU(ug.apply(UTranslate.dx(x1 + delta / 2.0)));
            }
            day = this.increment(day, this.printScale);
        }
    }

    private LocalDate increment(LocalDate day, PrintScale printScale) {
        if (printScale == PrintScale.WEEKLY) {
            return day.plusDays(7L);
        }
        return day.plusDays(1L);
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawSmallVlinesDay(ug, this.getTimeScale(), totalHeightWithoutFooter);
        this.drawSimpleDayCounter(ug, this.getTimeScale());
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        ug = ug.apply(UTranslate.dy(3.0));
        this.drawSimpleDayCounter(ug, this.getTimeScale());
    }

    protected final void drawTextsBackground(UGraphic ug, double totalHeightWithoutFooter) {
        double height = totalHeightWithoutFooter - this.getFullHeaderHeight(ug.getStringBounder());
        Pending pending = null;
        LocalDate day = this.getMinDay();
        while (day.compareTo(this.getMaxDay()) <= 0) {
            TimePoint wink = TimePoint.ofStartOfDay(day);
            double x1 = this.getTimeScale().getPosition(wink);
            double x2 = this.getTimeScale().getPosition(wink);
            HColor back = this.thParam.getColor(wink);
            if (back == null) {
                if (pending != null) {
                    pending.draw(ug, height);
                }
                pending = null;
            } else {
                if (pending != null && !pending.color.equals(back)) {
                    pending.draw(ug, height);
                    pending = null;
                }
                if (pending == null) {
                    pending = new Pending(back, x1, x2);
                } else {
                    pending.x2 = x2;
                }
            }
            day = day.plusDays(1L);
        }
    }

    class Pending {
        final double x1;
        double x2;
        final HColor color;

        Pending(HColor color, double x1, double x2) {
            this.x1 = x1;
            this.x2 = x2;
            this.color = color;
        }

        public void draw(UGraphic ug, double height) {
            TimeHeaderChronology.this.drawRectangle(ug.apply(this.color.bg()), height, this.x1, this.x2);
        }
    }
}

