/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cli;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.plantuml.cli.Exit;
import net.sourceforge.plantuml.crash.ReportLog;
import net.sourceforge.plantuml.dot.GraphvizUtils;
import net.sourceforge.plantuml.security.SecurityProfile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.syntax.LanguageDescriptor;
import net.sourceforge.plantuml.teavm.TeaVM;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.PSystemVersion;
import net.sourceforge.plantuml.version.Version;

public class OptionPrint {
    private static String hostname;

    public static Collection<String> interestingProperties() {
        if (TeaVM.isTeaVM()) {
            return Collections.emptyList();
        }
        Properties p = System.getProperties();
        List<String> all = SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE ? Arrays.asList("java.runtime.name", "Java Runtime", "java.vm.name", "JVM", "java.runtime.version", "Java Version", "os.name", "Operating System", "os.version", "OS Version", "file.encoding", "Default Encoding", "user.language", "Language", "user.country", "Country") : Arrays.asList("java.runtime.name", "Java Runtime", "java.vm.name", "JVM", "file.encoding", "Default Encoding", "user.language", "Language", "user.country", "Country");
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < all.size(); i += 2) {
            result.add(all.get(i + 1) + ": " + p.getProperty(all.get(i)));
        }
        return result;
    }

    public static Collection<String> interestingValues() {
        ArrayList<Object> strings = new ArrayList<Object>();
        if (!TeaVM.isTeaVM()) {
            strings.add(" ");
            strings.add("PLANTUML_LIMIT_SIZE: " + GraphvizUtils.getenvImageLimit());
            if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
                strings.add("Processors: " + Runtime.getRuntime().availableProcessors());
                long freeMemory = Runtime.getRuntime().freeMemory();
                long maxMemory = Runtime.getRuntime().maxMemory();
                long totalMemory = Runtime.getRuntime().totalMemory();
                long usedMemory = totalMemory - freeMemory;
                int threadActiveCount = Thread.activeCount();
                strings.add("Max Memory: " + OptionPrint.format(maxMemory));
                strings.add("Total Memory: " + OptionPrint.format(totalMemory));
                strings.add("Free Memory: " + OptionPrint.format(freeMemory));
                strings.add("Used Memory: " + OptionPrint.format(usedMemory));
                strings.add("Thread Active Count: " + threadActiveCount);
            }
        }
        return Collections.unmodifiableCollection(strings);
    }

    public static void printCheckGraphviz() {
        ReportLog result = new ReportLog();
        int errorCode = GraphvizUtils.addDotStatus(result, false);
        for (String s : result) {
            if (errorCode == 0) {
                System.out.println(s);
                continue;
            }
            System.err.println(s);
        }
        Exit.exit(errorCode);
    }

    public static void printLicense() {
        for (String s : License.getCurrent().getTextFull()) {
            System.out.println(s);
        }
    }

    public static void printVersion() {
        System.out.println(Version.fullDescription());
        System.out.println("(" + String.valueOf(License.getCurrent()) + " source distribution)");
        System.out.println();
        System.out.println("Build Version: 1.2026.2");
        System.out.println("Git Commit: N/A");
        System.out.println("Compile Time: " + Version.compileTimeString());
        System.out.println();
        for (String v : OptionPrint.interestingProperties()) {
            System.out.println(v);
        }
        for (String v : OptionPrint.interestingValues()) {
            System.out.println(v);
        }
        System.out.println();
        ReportLog result = new ReportLog();
        int errorCode = GraphvizUtils.addDotStatus(result, false);
        for (String s : result) {
            System.out.println(s);
        }
        Exit.exit(errorCode);
    }

    public static synchronized String getHostName() {
        if (hostname == null) {
            hostname = OptionPrint.getHostNameSlow();
        }
        return hostname;
    }

    private static String getHostNameSlow() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (Throwable e) {
            Map<String, String> env = System.getenv();
            if (env.containsKey("COMPUTERNAME")) {
                return env.get("COMPUTERNAME");
            }
            if (env.containsKey("HOSTNAME")) {
                return env.get("HOSTNAME");
            }
            return "Unknown Computer";
        }
    }

    private static String format(long value) {
        return String.format(Locale.US, "%,d", value);
    }

    public static void printAbout() {
        for (String s : PSystemVersion.getAuthorsStrings(false)) {
            System.out.println(s);
        }
    }

    public static void printListKeywords() {
        new LanguageDescriptor().print(System.out);
    }
}

