/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.emoji;

import java.util.Objects;
import net.atmp.PixelImage;
import net.sourceforge.plantuml.klimt.AffineTransformType;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.klimt.sprite.Sprite;

public class SpriteSvgNanoParser
implements Sprite {
    private final UImage img;

    public SpriteSvgNanoParser(PortableImage img) {
        this.img = new UImage(new PixelImage(Objects.requireNonNull(img), AffineTransformType.TYPE_BILINEAR));
    }

    @Override
    public TextBlock asTextBlock(HColor fontColor, final HColor forcedColor, final double scale, HColor backColor) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                ColorMapper colorMapper = ug.getColorMapper();
                if (colorMapper == ColorMapper.MONOCHROME) {
                    ug.draw(SpriteSvgNanoParser.this.img.monochrome().scale(scale));
                } else if (forcedColor == null) {
                    ug.draw(SpriteSvgNanoParser.this.img.scale(scale));
                } else {
                    ug.draw(SpriteSvgNanoParser.this.img.muteColor(forcedColor.toColor(colorMapper)).scale(scale));
                }
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D((double)SpriteSvgNanoParser.this.img.getWidth() * scale, (double)SpriteSvgNanoParser.this.img.getHeight() * scale);
            }
        };
    }
}

