/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt;

import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;

public class Fashion {
    private final HColor backColor;
    private final HColor foreColor;
    private final UStroke stroke;
    private final double deltaShadow;
    private final double roundCorner;
    private final double diagonalCorner;

    private Fashion(HColor backColor, HColor foreColor, UStroke stroke, double deltaShadow, double roundCorner, double diagonalCorner) {
        this.backColor = backColor;
        this.foreColor = foreColor;
        this.stroke = stroke;
        this.deltaShadow = deltaShadow;
        this.roundCorner = roundCorner;
        this.diagonalCorner = diagonalCorner;
    }

    public String toString() {
        return super.toString() + " backColor=" + String.valueOf(this.backColor) + " foreColor=" + String.valueOf(this.foreColor);
    }

    public final UGraphic apply(UGraphic ug) {
        ug = this.applyColors(ug);
        ug = this.applyStroke(ug);
        return ug;
    }

    public UGraphic applyColors(UGraphic ug) {
        ug = this.foreColor == null ? ug.apply(HColors.none()) : ug.apply(this.foreColor);
        ug = this.backColor == null ? ug.apply(HColors.none().bg()) : ug.apply(this.backColor.bg());
        return ug;
    }

    public UGraphic applyStroke(UGraphic ug) {
        return ug.apply(this.stroke);
    }

    public Fashion(HColor backColor, HColor foreColor) {
        this(backColor, foreColor, UStroke.simple(), 0.0, 0.0, 0.0);
    }

    public Fashion withShadow(double deltaShadow2) {
        return new Fashion(this.backColor, this.foreColor, this.stroke, deltaShadow2, this.roundCorner, this.diagonalCorner);
    }

    public Fashion withDeltaShadow(double deltaShadow2) {
        return new Fashion(this.backColor, this.foreColor, this.stroke, deltaShadow2, this.roundCorner, this.diagonalCorner);
    }

    public Fashion withStroke(UStroke newStroke) {
        return new Fashion(this.backColor, this.foreColor, newStroke, this.deltaShadow, this.roundCorner, this.diagonalCorner);
    }

    public Fashion withBackColor(HColor backColor) {
        return new Fashion(backColor, this.foreColor, this.stroke, this.deltaShadow, this.roundCorner, this.diagonalCorner);
    }

    public Fashion withForeColor(HColor foreColor) {
        return new Fashion(this.backColor, foreColor, this.stroke, this.deltaShadow, this.roundCorner, this.diagonalCorner);
    }

    public Fashion withCorner(double roundCorner, double diagonalCorner) {
        return new Fashion(this.backColor, this.foreColor, this.stroke, this.deltaShadow, roundCorner, diagonalCorner);
    }

    public HColor getBackColor() {
        return this.backColor;
    }

    public HColor getForeColor() {
        return this.foreColor;
    }

    public UStroke getStroke() {
        return this.stroke;
    }

    public boolean isShadowing() {
        return this.deltaShadow > 0.0;
    }

    public double getDeltaShadow() {
        return this.deltaShadow;
    }

    public double getRoundCorner() {
        return this.roundCorner;
    }

    public double getDiagonalCorner() {
        return this.diagonalCorner;
    }
}

