/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.color;

import net.sourceforge.plantuml.klimt.awt.XColor;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.ColorOrder;
import net.sourceforge.plantuml.klimt.color.ColorUtils;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HSLColor;
import net.sourceforge.plantuml.teavm.TeaVM;

public class HColorSimple
extends HColor {
    private final XColor color;
    private final HColor dark;
    private final HColor.TransparentFillBehavior transparentFillBehavior;

    public String toString() {
        boolean withDark = this.dark != null;
        StringBuilder sb = new StringBuilder();
        if (withDark) {
            sb.append("WITHDARK ");
        }
        sb.append(this.color.toString());
        sb.append(" \u03b1=");
        sb.append(this.color.getAlpha());
        if (this.isTransparent()) {
            sb.append(" transparent");
        }
        if (this.transparentFillBehavior != HColor.TransparentFillBehavior.WITH_FILL_NONE) {
            sb.append(" ").append((Object)this.transparentFillBehavior);
        }
        return sb.toString();
    }

    @Override
    public String asString() {
        if (this.isTransparent()) {
            return "transparent";
        }
        int red = this.color.getRed();
        int green = this.color.getGreen();
        int blue = this.color.getBlue();
        int alpha = this.color.getAlpha();
        if (alpha == 255) {
            return String.format("#%02X%02X%02X", red, green, blue);
        }
        return String.format("#%02x%02x%02x%02x", alpha, red, green, blue);
    }

    public boolean equals(Object other) {
        if (!(other instanceof HColorSimple)) {
            return false;
        }
        return this.color.equals(((HColorSimple)other).color);
    }

    public int hashCode() {
        return this.color.hashCode();
    }

    @Override
    public HColor lighten(int ratio) {
        if (TeaVM.isTeaVM()) {
            return this;
        }
        float[] hsl = new HSLColor(this.color).getHSL();
        hsl[2] = (float)((double)hsl[2] + (double)hsl[2] * ((double)ratio / 100.0));
        return HColorSimple.create(new HSLColor(hsl).getRGB());
    }

    @Override
    public HColor darken(int ratio) {
        if (TeaVM.isTeaVM()) {
            return this;
        }
        float[] hsl = new HSLColor(this.color).getHSL();
        hsl[2] = (float)((double)hsl[2] - (double)hsl[2] * ((double)ratio / 100.0));
        return HColorSimple.create(new HSLColor(hsl).getRGB());
    }

    @Override
    public HColor reverseHsluv() {
        return HColorSimple.create(ColorUtils.reverseHsluv(this.color));
    }

    @Override
    public HColor reverse() {
        return HColorSimple.create(ColorOrder.RGB.getReverse(this.color));
    }

    @Override
    public boolean isDark() {
        return ColorUtils.getGrayScale(this.color) < 128;
    }

    @Override
    public boolean isTransparent() {
        return this.color.getAlpha() == 0;
    }

    @Override
    public HColor.TransparentFillBehavior transparentFillBehavior() {
        return this.transparentFillBehavior;
    }

    public static HColorSimple create(XColor c) {
        return new HColorSimple(c, null, HColor.TransparentFillBehavior.WITH_FILL_NONE);
    }

    private HColorSimple(XColor c, HColor dark, HColor.TransparentFillBehavior transparentFillBehavior) {
        this.color = c;
        this.dark = dark;
        this.transparentFillBehavior = transparentFillBehavior;
    }

    public XColor getAwtColor() {
        return this.color;
    }

    public HColor asMonochrome() {
        return HColorSimple.create(ColorUtils.getGrayScaleColor(this.color));
    }

    public HColor asMonochrome(HColorSimple colorForMonochrome, double minGray, double maxGray) {
        XColor tmp = ColorUtils.getGrayScaleColor(this.color);
        int gray = tmp.getGreen();
        assert (gray == tmp.getBlue());
        assert (gray == tmp.getRed());
        double coef = ((double)gray - minGray) / 256.0;
        XColor result = ColorUtils.grayToColor(coef, colorForMonochrome.color);
        return HColorSimple.create(result);
    }

    @Override
    public XColor toColor(ColorMapper mapper) {
        if (this.isTransparent()) {
            return this.getAwtColor();
        }
        return mapper.fromColorSimple(this);
    }

    public static HColorSimple unlinear(HColorSimple color1, HColorSimple color2, int completionInt) {
        HSLColor col1 = new HSLColor(color1.color);
        HSLColor col2 = new HSLColor(color2.color);
        float[] hsl1 = col1.getHSL();
        float[] hsl2 = col2.getHSL();
        if (completionInt > 100) {
            completionInt = 100;
        }
        float completion = (float)((double)completionInt / 100.0);
        completion = completion * completion * completion;
        float[] hsl = HColorSimple.linear(completion, hsl1, hsl2);
        HSLColor col = new HSLColor(hsl);
        return HColorSimple.create(col.getRGB());
    }

    private static float[] linear(float factor, float[] hsl1, float[] hsl2) {
        float h = HColorSimple.linear(factor, hsl1[0], hsl2[0]);
        float s = HColorSimple.linear(factor, hsl1[1], hsl2[1]);
        float l = HColorSimple.linear(factor, hsl1[2], hsl2[2]);
        return new float[]{h, s, l};
    }

    private static float linear(float factor, float x, float y) {
        return x + (y - x) * factor;
    }

    @Override
    public HColor opposite() {
        XColor mono = ColorUtils.getGrayScaleColor(this.color);
        int grayScale = 255 - mono.getGreen() > 127 ? 255 : 0;
        return HColorSimple.create(new XColor(grayScale, grayScale, grayScale));
    }

    public int distanceTo(HColorSimple other) {
        return ColorUtils.distance(this.color, other.color);
    }

    public boolean isGray() {
        return this.color.getRed() == this.color.getGreen() && this.color.getGreen() == this.color.getBlue();
    }

    @Override
    public HColor withDark(HColor dark) {
        return new HColorSimple(this.color, dark, this.transparentFillBehavior);
    }

    @Override
    public HColor withTransparentFillBehavior(HColor.TransparentFillBehavior transparentFillBehavior) {
        return new HColorSimple(this.color, this.dark, transparentFillBehavior);
    }

    @Override
    public HColor darkSchemeTheme() {
        if (this.dark == null) {
            return this;
        }
        return this.dark;
    }
}

