/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.g2d;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.geom.EnsureVisible;
import net.sourceforge.plantuml.klimt.shape.UImage;

public class DriverImageG2d
implements UDriver<UImage, Graphics2D> {
    private final EnsureVisible visible;
    private final double dpiFactor;

    public DriverImageG2d(double dpiFactor, EnsureVisible visible) {
        this.visible = visible;
        this.dpiFactor = dpiFactor;
    }

    @Override
    public void draw(UImage shape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        this.visible.ensureVisible(x, y);
        this.visible.ensureVisible(x + (double)shape.getWidth(), y + (double)shape.getHeight());
        if (this.dpiFactor == 1.0) {
            g2d.drawImage((Image)shape.getImage(1.0).getBufferedImage(), (int)x, (int)y, null);
        } else {
            AffineTransform back = g2d.getTransform();
            g2d.scale(1.0 / this.dpiFactor, 1.0 / this.dpiFactor);
            g2d.drawImage((Image)shape.getImage(this.dpiFactor).getBufferedImage(), (int)(x * this.dpiFactor), (int)(y * this.dpiFactor), null);
            g2d.setTransform(back);
        }
    }
}

