/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.g2d;

import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;
import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.awt.XColor;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorGradient;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.drawing.g2d.DriverLineG2d;
import net.sourceforge.plantuml.klimt.drawing.g2d.DriverRectangleG2d;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontStyle;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.font.UFontImpl;
import net.sourceforge.plantuml.klimt.geom.EnsureVisible;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.text.StyledString;

public class DriverTextG2d
implements UDriver<UText, Graphics2D> {
    private final EnsureVisible visible;
    private final StringBounder stringBounder;

    public DriverTextG2d(EnsureVisible visible, StringBounder stringBounder) {
        this.visible = visible;
        this.stringBounder = stringBounder;
    }

    @Override
    public void draw(UText shape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        FontConfiguration fontConfiguration = shape.getFontConfiguration();
        if (fontConfiguration.getColor().isTransparent()) {
            return;
        }
        String text = shape.getText();
        List<StyledString> strings = StyledString.build(text);
        for (StyledString styledString : strings) {
            FontConfiguration fc = styledString.getStyle() == FontStyle.BOLD ? fontConfiguration.bold() : fontConfiguration;
            x += this.printSingleText(g2d, fc, styledString.getText(), x, y, mapper, shape.getOrientation());
        }
    }

    private double printSingleText(Graphics2D g2d, FontConfiguration fontConfiguration, String text, double x, double y, ColorMapper mapper, int orientation) {
        UFont font = fontConfiguration.getFont();
        HColor extended = fontConfiguration.getExtendedColor();
        XDimension2D dim = this.stringBounder.calculateDimension(font, text);
        double height = Math.max(10.0, dim.getHeight());
        double width = dim.getWidth();
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setFont(UFontImpl.getUnderlayingFont(font, text));
        if (orientation == 90) {
            AffineTransform orig = g2d.getTransform();
            g2d.translate(x, y);
            g2d.rotate(-1.5707963267948966);
            g2d.drawString(text, 0, 0);
            g2d.setTransform(orig);
        } else if (orientation == 270) {
            AffineTransform orig = g2d.getTransform();
            g2d.translate(x, y);
            g2d.rotate(1.5707963267948966);
            g2d.drawString(text, 0, 0);
            g2d.setTransform(orig);
        } else if (orientation == 270) {
            AffineTransform orig = g2d.getTransform();
            g2d.translate(x, y);
            g2d.rotate(-1.5707963267948966);
            g2d.drawString(text, 0, 0);
            g2d.setTransform(orig);
        } else if (orientation == 0) {
            if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR)) {
                Rectangle2D.Double area = new Rectangle2D.Double(x, y - height + 1.5, width, height);
                if (extended instanceof HColorGradient) {
                    GradientPaint paint = DriverRectangleG2d.getPaintGradient(x, y, mapper, width, height, extended);
                    g2d.setPaint(paint);
                    g2d.fill(area);
                } else {
                    XColor backColor = extended.toColor(mapper);
                    if (backColor != null) {
                        g2d.setColor(backColor.toAwtColor());
                        g2d.setBackground(backColor.toAwtColor());
                        g2d.fill(area);
                    }
                }
            }
            this.visible.ensureVisible(x, y - height + 1.5);
            this.visible.ensureVisible(x + width, y + 1.5);
            g2d.setColor(fontConfiguration.getColor().toColor(mapper).toAwtColor());
            g2d.drawString(text, (float)x, (float)y);
            if (fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
                UStroke stroke;
                if (extended != null) {
                    g2d.setColor(extended.toColor(mapper).toAwtColor());
                }
                if ((stroke = fontConfiguration.getUnderlineStroke()).getThickness() > 0.0) {
                    DriverLineG2d.manageStroke(stroke, g2d);
                    int ypos = (int)(y + 2.5);
                    g2d.drawLine((int)x, ypos, (int)(x + width), ypos);
                    g2d.setStroke(new BasicStroke());
                }
            }
            if (fontConfiguration.containsStyle(FontStyle.WAVE)) {
                int ypos = (int)(y + 2.5) - 1;
                if (extended != null) {
                    g2d.setColor(extended.toColor(mapper).toAwtColor());
                }
                int i = (int)x;
                while ((double)i < x + width - 5.0) {
                    g2d.drawLine(i, ypos - 0, i + 3, ypos + 1);
                    g2d.drawLine(i + 3, ypos + 1, i + 6, ypos - 0);
                    i += 6;
                }
            }
            if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
                FontMetrics fm = g2d.getFontMetrics(UFontImpl.getUnderlayingFont(font, text));
                int ypos = (int)(y - (double)fm.getDescent() - 0.5);
                if (extended != null) {
                    g2d.setColor(extended.toColor(mapper).toAwtColor());
                }
                g2d.setStroke(new BasicStroke(1.5f));
                g2d.drawLine((int)x, ypos, (int)(x + width), ypos);
                g2d.setStroke(new BasicStroke());
            }
        }
        return width;
    }
}

